/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallerInternals;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.List;

abstract class SplitInstaller {
    static final int WAIT_ASYNC_OAT_TIME = 10000;
    static final int MAX_WAIT_COUNT = 120;

    SplitInstaller() {
    }

    public abstract InstallResult install(SplitInfo var1) throws InstallException;

    protected abstract void validateSignature(File var1) throws InstallException;

    protected abstract List<File> extractMultiDex(SplitInfo var1, File var2) throws InstallException;

    protected abstract File extractLib(SplitInfo var1, File var2) throws InstallException;

    protected abstract List<DexFile> optimizeDex(List<File> var1, File var2) throws InstallException;

    protected abstract void checkOptimizedDexFiles(List<File> var1, List<DexFile> var2) throws InstallException;

    protected abstract void createInstalledMark(SplitInfo var1) throws InstallException;

    protected abstract Context getApplicationContext();

    static final class InstallException
    extends Exception {
        private final int errorCode;

        InstallException(int errorCode, Exception e) {
            super(new StringBuilder(32).append("Split Install Error: ").append(errorCode).toString(), e);
            this.errorCode = errorCode;
        }

        int getErrorCode() {
            return this.errorCode;
        }
    }

    static final class DexOptimizer {
        private final File dexFile;
        private final File optimizedDir;

        DexOptimizer(File dexFile, File optimizedDir) {
            this.dexFile = dexFile;
            this.optimizedDir = optimizedDir;
        }

        DexFile optimize() throws IOException {
            String optimizedPath = SplitInstallerInternals.optimizedPathFor(this.dexFile, this.optimizedDir);
            return DexFile.loadDex((String)this.dexFile.getAbsolutePath(), (String)optimizedPath, (int)0);
        }
    }

    class InstallResult {
        final String splitName;
        final File splitDir;
        final File apkFile;
        final File libFile;
        final File optDir;
        final List<File> multiDexFiles;
        final boolean dependenciesInstalled;

        InstallResult(@NonNull String splitName, @NonNull File splitDir, @Nullable File apkFile, @Nullable File optDir, @Nullable File libFile, List<File> multiDexFiles, boolean dependenciesInstalled) {
            this.splitName = splitName;
            this.splitDir = splitDir;
            this.apkFile = apkFile;
            this.optDir = optDir;
            this.libFile = libFile;
            this.multiDexFiles = multiDexFiles;
            this.dependenciesInstalled = dependenciesInstalled;
        }
    }
}

