/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.util.ArraySet;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitAABInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitBaseInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitdownload.DownloadCallback;
import com.iqiyi.android.qigsaw.core.splitdownload.DownloadRequest;
import com.iqiyi.android.qigsaw.core.splitdownload.Downloader;
import com.iqiyi.android.qigsaw.core.splitinstall.DeferredDownloadCallback;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitDownloadPreprocessor;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallInternalSessionState;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallSessionManager;
import com.iqiyi.android.qigsaw.core.splitinstall.StartDownloadCallback;
import com.iqiyi.android.qigsaw.core.splitinstall.remote.SplitInstallSupervisor;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManager;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfoManagerService;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

final class SplitInstallSupervisorImpl
extends SplitInstallSupervisor {
    private static final String TAG = "Split:SplitInstallSupervisorImpl";
    private final Context appContext;
    private final SplitInstallSessionManager sessionManager;
    private final Downloader userDownloader;
    private final long downloadSizeThresholdValue;
    private final Set<String> installedSplitInstallInfo;
    private final Class<?> obtainUserConfirmationActivityClass;

    SplitInstallSupervisorImpl(Context appContext, SplitInstallSessionManager sessionManager, Downloader userDownloader, Class<? extends Activity> obtainUserConfirmationActivityClass) {
        this.appContext = appContext;
        this.sessionManager = sessionManager;
        this.userDownloader = userDownloader;
        long downloadSizeThreshold = userDownloader.getDownloadSizeThresholdWhenUsingMobileData();
        this.downloadSizeThresholdValue = downloadSizeThreshold < 0L ? Long.MAX_VALUE : downloadSizeThreshold;
        this.installedSplitInstallInfo = new SplitAABInfoProvider(this.appContext).getInstalledSplitsForAAB();
        this.obtainUserConfirmationActivityClass = obtainUserConfirmationActivityClass;
    }

    @Override
    public void startInstall(List<Bundle> moduleNames, SplitInstallSupervisor.Callback callback) {
        List<String> moduleNameList = SplitInstallSupervisorImpl.unBundleModuleNames(moduleNames);
        int errorCode = this.onPreInstallSplits(moduleNameList);
        if (errorCode != 0) {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(errorCode));
        } else {
            List<SplitInfo> needInstallSplits = this.getNeed2BeInstalledSplits(moduleNameList);
            if (!this.isAllSplitsBuiltIn(needInstallSplits) && !SplitInstallSupervisorImpl.isNetworkAvailable(this.appContext)) {
                callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-6));
                return;
            }
            Set<String> allDependencies = this.getAllDependencies(moduleNameList, needInstallSplits);
            if (!allDependencies.isEmpty()) {
                SplitLog.e((String)TAG, (String)"QIGSAW WARNING: Your request must contains all dynamic feature dependencies, otherwise it maybe occur runtime error!", (Object[])new Object[0]);
            }
            this.startDownloadSplits(moduleNameList, needInstallSplits, callback);
        }
    }

    private Set<String> getAllDependencies(List<String> moduleNames, List<SplitInfo> needInstallSplits) {
        ArraySet splitDependencies = new ArraySet(0);
        for (SplitInfo info : needInstallSplits) {
            List dependencies = info.getDependencies();
            if (dependencies == null) continue;
            splitDependencies.addAll(dependencies);
        }
        if (!splitDependencies.isEmpty()) {
            splitDependencies.removeAll(moduleNames);
        }
        return splitDependencies;
    }

    @Override
    public void deferredInstall(List<Bundle> moduleNames, SplitInstallSupervisor.Callback callback) {
        List<String> moduleNameList = SplitInstallSupervisorImpl.unBundleModuleNames(moduleNames);
        int errorCode = this.onPreInstallSplits(moduleNameList);
        if (errorCode == 0) {
            if (!this.getInstalledSplitInstallInfo().isEmpty()) {
                if (this.getInstalledSplitInstallInfo().containsAll(moduleNameList)) {
                    callback.onDeferredInstall(null);
                }
            } else {
                List<SplitInfo> needInstallSplits = this.getNeed2BeInstalledSplits(moduleNameList);
                this.deferredDownloadSplits(moduleNameList, needInstallSplits, callback);
            }
        } else {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(errorCode));
        }
    }

    @Override
    public void deferredUninstall(List<Bundle> moduleNames, SplitInstallSupervisor.Callback callback) {
        callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-100));
    }

    @Override
    public void cancelInstall(int sessionId, SplitInstallSupervisor.Callback callback) {
        SplitLog.i((String)TAG, (String)"start to cancel session id %d installation", (Object[])new Object[]{sessionId});
        SplitInstallInternalSessionState sessionState = this.sessionManager.getSessionState(sessionId);
        if (sessionState == null) {
            SplitLog.i((String)TAG, (String)"Session id is not found!", (Object[])new Object[0]);
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-4));
            return;
        }
        if (sessionState.status() == 1 || sessionState.status() == 2) {
            boolean ret = this.userDownloader.cancelDownloadSync(sessionId);
            SplitLog.d((String)TAG, (String)("result of cancel request : " + ret), (Object[])new Object[0]);
            if (ret) {
                callback.onCancelInstall(sessionId, null);
            } else {
                callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-3));
            }
        } else {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-3));
        }
    }

    @Override
    public void getSessionState(int sessionId, SplitInstallSupervisor.Callback callback) {
        SplitInstallInternalSessionState sessionStateVariant = this.sessionManager.getSessionState(sessionId);
        if (sessionStateVariant == null) {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-4));
            return;
        }
        callback.onGetSession(sessionId, SplitInstallInternalSessionState.transform2Bundle(sessionStateVariant));
    }

    @Override
    public void getSessionStates(SplitInstallSupervisor.Callback callback) {
        List<SplitInstallInternalSessionState> sessionStateVariantList = this.sessionManager.getSessionStates();
        if (sessionStateVariantList.isEmpty()) {
            callback.onGetSessionStates(Collections.emptyList());
        } else {
            ArrayList<Bundle> sessionStates = new ArrayList<Bundle>(0);
            for (SplitInstallInternalSessionState sessionStateVariant : sessionStateVariantList) {
                sessionStates.add(SplitInstallInternalSessionState.transform2Bundle(sessionStateVariant));
            }
            callback.onGetSessionStates(sessionStates);
        }
    }

    @Override
    public boolean continueInstallWithUserConfirmation(int sessionId) {
        SplitInstallInternalSessionState sessionState = this.sessionManager.getSessionState(sessionId);
        if (sessionState != null) {
            StartDownloadCallback downloadCallback = new StartDownloadCallback(this.appContext, sessionId, this.sessionManager, sessionState.moduleNames(), sessionState.needInstalledSplits);
            this.sessionManager.changeSessionState(sessionId, 1);
            this.sessionManager.emitSessionState(sessionState);
            this.userDownloader.startDownload(sessionState.sessionId(), sessionState.downloadRequests, (DownloadCallback)downloadCallback);
            return true;
        }
        return false;
    }

    @Override
    public boolean cancelInstallWithoutUserConfirmation(int sessionId) {
        SplitInstallInternalSessionState sessionState = this.sessionManager.getSessionState(sessionId);
        if (sessionState != null) {
            this.sessionManager.changeSessionState(sessionState.sessionId(), 7);
            this.sessionManager.emitSessionState(sessionState);
            return true;
        }
        return false;
    }

    private boolean isAllSplitsBuiltIn(List<SplitInfo> needInstallSplits) {
        for (SplitInfo info : needInstallSplits) {
            if (info.isBuiltIn()) continue;
            return false;
        }
        return true;
    }

    private int onPreInstallSplits(List<String> moduleNames) {
        if (!this.getInstalledSplitInstallInfo().isEmpty()) {
            if (!this.getInstalledSplitInstallInfo().containsAll(moduleNames)) {
                return -3;
            }
        } else {
            int errorCode = this.checkInternalErrorCode();
            if (errorCode == 0) {
                errorCode = this.checkRequestErrorCode(moduleNames);
            }
            return errorCode;
        }
        return 0;
    }

    private int checkRequestErrorCode(List<String> moduleNames) {
        if (!this.isRequestValid(moduleNames)) {
            return -3;
        }
        if (!this.isModuleAvailable(moduleNames)) {
            return -2;
        }
        return 0;
    }

    private int checkInternalErrorCode() {
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        if (manager == null) {
            SplitLog.w((String)TAG, (String)"Failed to fetch SplitInfoManager instance!", (Object[])new Object[0]);
            return -100;
        }
        Collection allSplits = manager.getAllSplitInfo(this.appContext);
        if (allSplits == null || allSplits.isEmpty()) {
            SplitLog.w((String)TAG, (String)"Failed to parse json file of split info!", (Object[])new Object[0]);
            return -100;
        }
        String baseAppVersionName = manager.getBaseAppVersionName(this.appContext);
        String versionName = SplitBaseInfoProvider.getVersionName();
        if (TextUtils.isEmpty((CharSequence)baseAppVersionName) || !baseAppVersionName.equals(versionName)) {
            SplitLog.w((String)TAG, (String)"Failed to match base app version-name excepted base app version %s but %s!", (Object[])new Object[]{versionName, baseAppVersionName});
            return -100;
        }
        String qigsawId = manager.getQigsawId(this.appContext);
        String baseAppQigsawId = SplitBaseInfoProvider.getQigsawId();
        if (TextUtils.isEmpty((CharSequence)qigsawId) || !qigsawId.equals(baseAppQigsawId)) {
            SplitLog.w((String)TAG, (String)"Failed to match base app qigsaw-version excepted %s but %s!", (Object[])new Object[]{baseAppQigsawId, qigsawId});
            return -100;
        }
        return 0;
    }

    private Set<String> getInstalledSplitInstallInfo() {
        return this.installedSplitInstallInfo;
    }

    private List<SplitInfo> getNeed2BeInstalledSplits(List<String> moduleNames) {
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        assert (manager != null);
        Collection allSplits = manager.getAllSplitInfo(this.appContext);
        ArrayList<SplitInfo> needInstallSplits = new ArrayList<SplitInfo>(moduleNames.size());
        for (SplitInfo info : allSplits) {
            if (!moduleNames.contains(info.getSplitName())) continue;
            needInstallSplits.add(info);
        }
        return needInstallSplits;
    }

    private void deferredDownloadSplits(List<String> moduleNames, List<SplitInfo> needInstallSplits, SplitInstallSupervisor.Callback callback) {
        try {
            long[] result = this.onPreDownloadSplits(needInstallSplits);
            callback.onDeferredInstall(null);
            long realTotalBytesNeedToDownload = result[1];
            int sessionId = SplitInstallSupervisorImpl.createSessionId(needInstallSplits);
            SplitLog.d((String)TAG, (String)("DeferredInstall session id: " + sessionId), (Object[])new Object[0]);
            DeferredDownloadCallback downloadCallback = new DeferredDownloadCallback(this.appContext, moduleNames, needInstallSplits);
            if (realTotalBytesNeedToDownload == 0L) {
                SplitLog.d((String)TAG, (String)"Splits have been downloaded, install them directly!", (Object[])new Object[0]);
                downloadCallback.onCompleted();
            } else {
                boolean usingMobileDataPermitted = realTotalBytesNeedToDownload < this.downloadSizeThresholdValue && !this.userDownloader.isDeferredDownloadOnlyWhenUsingWifiData();
                this.userDownloader.deferredDownload(sessionId, this.createDownloadRequests(needInstallSplits), (DownloadCallback)downloadCallback, usingMobileDataPermitted);
            }
        }
        catch (IOException e) {
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-99));
            SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to copy builtin split apks(%s)", (Object[])new Object[]{"onDeferredInstall"});
        }
    }

    private void startDownloadSplits(List<String> moduleNames, List<SplitInfo> needInstallSplits, SplitInstallSupervisor.Callback callback) {
        if (this.sessionManager.isActiveSessionsLimitExceeded()) {
            SplitLog.w((String)TAG, (String)"Start install request error code: ACTIVE_SESSIONS_LIMIT_EXCEEDED", (Object[])new Object[0]);
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-1));
            return;
        }
        int sessionId = SplitInstallSupervisorImpl.createSessionId(needInstallSplits);
        List<DownloadRequest> downloadRequests = this.createDownloadRequests(needInstallSplits);
        SplitLog.d((String)TAG, (String)("startInstall session id: " + sessionId), (Object[])new Object[0]);
        SplitInstallInternalSessionState sessionState = this.sessionManager.getSessionState(sessionId);
        boolean needUserConfirmation = false;
        if (sessionState != null) {
            needUserConfirmation = sessionState.status() == 8;
        } else {
            sessionState = new SplitInstallInternalSessionState(sessionId, moduleNames, needInstallSplits, downloadRequests);
        }
        if (!needUserConfirmation && this.sessionManager.isIncompatibleWithExistingSession(moduleNames)) {
            SplitLog.w((String)TAG, (String)"Start install request error code: INCOMPATIBLE_WITH_EXISTING_SESSION", (Object[])new Object[0]);
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-8));
            return;
        }
        try {
            long[] result = this.onPreDownloadSplits(needInstallSplits);
            callback.onStartInstall(sessionId, null);
            this.sessionManager.setSessionState(sessionId, sessionState);
            long totalBytesToDownload = result[0];
            long realTotalBytesNeedToDownload = result[1];
            SplitLog.d((String)TAG, (String)"totalBytesToDownload: %d, realTotalBytesNeedToDownload: %d ", (Object[])new Object[]{totalBytesToDownload, realTotalBytesNeedToDownload});
            sessionState.setTotalBytesToDownload(totalBytesToDownload);
            StartDownloadCallback downloadCallback = new StartDownloadCallback(this.appContext, sessionId, this.sessionManager, moduleNames, needInstallSplits);
            if (realTotalBytesNeedToDownload <= 0L) {
                SplitLog.d((String)TAG, (String)"Splits have been downloaded, install them directly!", (Object[])new Object[0]);
                downloadCallback.onCompleted();
            } else {
                if (SplitInstallSupervisorImpl.isMobileAvailable(this.appContext) && realTotalBytesNeedToDownload > this.downloadSizeThresholdValue) {
                    this.startUserConfirmationActivity(sessionState, realTotalBytesNeedToDownload, downloadRequests);
                    return;
                }
                this.sessionManager.changeSessionState(sessionId, 1);
                this.sessionManager.emitSessionState(sessionState);
                this.userDownloader.startDownload(sessionId, downloadRequests, (DownloadCallback)downloadCallback);
            }
        }
        catch (IOException e) {
            SplitLog.w((String)TAG, (String)"Failed to copy internal splits", (Throwable)e);
            callback.onError(SplitInstallSupervisorImpl.bundleErrorCode(-99));
        }
    }

    private void startUserConfirmationActivity(SplitInstallInternalSessionState sessionState, long realTotalBytesNeedToDownload, List<DownloadRequest> requests) {
        Intent intent = new Intent();
        intent.putExtra("sessionId", sessionState.sessionId());
        intent.putParcelableArrayListExtra("downloadRequests", (ArrayList)requests);
        intent.putExtra("realTotalBytesNeedToDownload", realTotalBytesNeedToDownload);
        intent.putStringArrayListExtra("moduleNames", (ArrayList)sessionState.moduleNames());
        intent.setClass(this.appContext, this.obtainUserConfirmationActivityClass);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.appContext, (int)0, (Intent)intent, (int)0x8000000);
        sessionState.setUserConfirmationIntent(pendingIntent);
        this.sessionManager.changeSessionState(sessionState.sessionId(), 8);
        this.sessionManager.emitSessionState(sessionState);
    }

    private boolean isRequestValid(List<String> moduleNames) {
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        ArrayList<String> allSplits = new ArrayList<String>();
        assert (manager != null);
        Collection splitInfoList = manager.getAllSplitInfo(this.appContext);
        for (SplitInfo info : splitInfoList) {
            allSplits.add(info.getSplitName());
        }
        return allSplits.containsAll(moduleNames);
    }

    private boolean isModuleAvailable(List<String> moduleNames) {
        SplitInfoManager manager = SplitInfoManagerService.getInstance();
        assert (manager != null);
        Collection splitInfoList = manager.getAllSplitInfo(this.appContext);
        for (String moduleName : moduleNames) {
            for (SplitInfo info : splitInfoList) {
                if (!info.getSplitName().equals(moduleName) || this.checkSplitInfo(info)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkSplitInfo(SplitInfo info) {
        return this.isCPUArchMatched(info) && this.isMinSdkVersionMatched(info);
    }

    private boolean isMinSdkVersionMatched(SplitInfo splitInfo) {
        return splitInfo.getMinSdkVersion() <= Build.VERSION.SDK_INT;
    }

    private boolean isCPUArchMatched(SplitInfo splitInfo) {
        if (splitInfo.hasLibs()) {
            String splitAbi = splitInfo.getLibInfo().getAbi();
            if (Build.VERSION.SDK_INT >= 21) {
                String[] supportABIs;
                for (String abi : supportABIs = Build.SUPPORTED_ABIS) {
                    if (!splitAbi.equals(abi)) continue;
                    return true;
                }
            } else {
                String cpuAbi = Build.CPU_ABI;
                if (splitAbi.equals(cpuAbi)) {
                    return true;
                }
            }
            return splitAbi.equals("armeabi");
        }
        return true;
    }

    private List<DownloadRequest> createDownloadRequests(Collection<SplitInfo> splitInfoList) {
        ArrayList<DownloadRequest> requests = new ArrayList<DownloadRequest>(splitInfoList.size());
        for (SplitInfo splitInfo : splitInfoList) {
            File splitDir = SplitPathManager.require().getSplitDir(splitInfo);
            String fileName = splitInfo.getSplitName() + ".apk";
            DownloadRequest request = DownloadRequest.newBuilder().url(splitInfo.getUrl()).fileDir(splitDir.getAbsolutePath()).fileName(fileName).moduleName(splitInfo.getSplitName()).build();
            requests.add(request);
        }
        return requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] onPreDownloadSplits(Collection<SplitInfo> splitInfoList) throws IOException {
        long totalBytesToDownload = 0L;
        long realTotalBytesNeedToDownload = 0L;
        for (SplitInfo splitInfo : splitInfoList) {
            File splitDir = SplitPathManager.require().getSplitDir(splitInfo);
            String fileName = splitInfo.getSplitName() + ".apk";
            File splitApk = new File(splitDir, fileName);
            this.checkSplitApkMd5(splitInfo, splitDir, splitApk);
            SplitDownloadPreprocessor processor = new SplitDownloadPreprocessor(splitDir, splitApk);
            try {
                processor.load(this.appContext, splitInfo);
            }
            finally {
                FileUtil.closeQuietly((Object)processor);
            }
            SplitLog.d((String)TAG, (String)("Split dir :" + splitDir.getAbsolutePath()), (Object[])new Object[0]);
            SplitLog.d((String)TAG, (String)("Split Name :" + fileName), (Object[])new Object[0]);
            totalBytesToDownload += splitInfo.getSize();
            if (splitApk.exists()) continue;
            realTotalBytesNeedToDownload += splitInfo.getSize();
        }
        return new long[]{totalBytesToDownload, realTotalBytesNeedToDownload};
    }

    private void checkSplitApkMd5(SplitInfo info, File splitDir, File splitApk) {
        if (FileUtil.isLegalFile((File)splitApk)) {
            String apkMd5 = FileUtil.getMD5((File)splitApk);
            if (TextUtils.isEmpty((CharSequence)apkMd5)) {
                if (info.getSize() != splitApk.length()) {
                    SplitLog.w((String)TAG, (String)"Split %s length change", (Object[])new Object[]{info.getSplitName()});
                    FileUtil.deleteDir((File)splitDir, (boolean)false);
                }
            } else if (!info.getMd5().equals(apkMd5)) {
                SplitLog.w((String)TAG, (String)"Split %s md5 change", (Object[])new Object[]{info.getSplitName()});
                FileUtil.deleteDir((File)splitDir, (boolean)false);
            }
        }
    }
}

