/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.extension;

import android.app.Application;
import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.SplitAABInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitBaseInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionException;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionManager;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionManagerImpl;
import com.iqiyi.android.qigsaw.core.extension.ContentProviderProxy;
import com.iqiyi.android.qigsaw.core.extension.SplitComponentInfoProvider;
import com.iqiyi.android.qigsaw.core.extension.fakecomponents.FakeActivity;
import com.iqiyi.android.qigsaw.core.extension.fakecomponents.FakeReceiver;
import com.iqiyi.android.qigsaw.core.extension.fakecomponents.FakeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Keep
public class AABExtension {
    private static final String TAG = "Split:AABExtension";
    private static final AtomicReference<AABExtension> sAABCompatReference = new AtomicReference<Object>(null);
    private final Map<String, List<ContentProviderProxy>> sSplitContentProviderMap = new HashMap<String, List<ContentProviderProxy>>();
    private final AABExtensionManager extensionManager;
    private final List<Application> aabApplications = new ArrayList<Application>();

    private AABExtension() {
        Set<String> splitNames = this.getSplitNames();
        this.extensionManager = new AABExtensionManagerImpl(new SplitComponentInfoProvider(splitNames));
    }

    public static AABExtension getInstance() {
        if (sAABCompatReference.get() == null) {
            sAABCompatReference.set(new AABExtension());
        }
        return sAABCompatReference.get();
    }

    public void createAndActiveSplitApplication(Context appContext, boolean qigsawMode) {
        if (qigsawMode) {
            return;
        }
        Set aabLoadedSplits = new SplitAABInfoProvider(appContext).getInstalledSplitsForAAB();
        if (!aabLoadedSplits.isEmpty()) {
            for (String splitName : aabLoadedSplits) {
                try {
                    Application app = this.createApplication(AABExtension.class.getClassLoader(), splitName);
                    if (app == null) continue;
                    this.activeApplication(app, appContext);
                    this.aabApplications.add(app);
                }
                catch (AABExtensionException e) {
                    SplitLog.w((String)TAG, (String)("Failed to create " + splitName + " application"), (Throwable)e);
                }
            }
        }
    }

    public void onApplicationCreate() {
        if (!this.aabApplications.isEmpty()) {
            for (Application application : this.aabApplications) {
                application.onCreate();
            }
        }
    }

    public Application createApplication(ClassLoader classLoader, String splitName) throws AABExtensionException {
        return this.extensionManager.createApplication(classLoader, splitName);
    }

    public void activeApplication(Application splitApplication, Context appContext) throws AABExtensionException {
        this.extensionManager.activeApplication(splitApplication, appContext);
    }

    void put(String splitName, ContentProviderProxy providerProxy) {
        List<ContentProviderProxy> providerProxies = this.sSplitContentProviderMap.get(splitName);
        if (providerProxies == null) {
            providerProxies = new ArrayList<ContentProviderProxy>();
            this.sSplitContentProviderMap.put(splitName, providerProxies);
        }
        providerProxies.add(providerProxy);
    }

    public void activateSplitProviders(ClassLoader classLoader, String splitName) throws AABExtensionException {
        List<ContentProviderProxy> providerProxies = this.sSplitContentProviderMap.get(splitName);
        if (providerProxies != null) {
            for (ContentProviderProxy providerProxy : providerProxies) {
                providerProxy.activateRealContentProvider(classLoader);
            }
        }
    }

    public Class<?> getFakeComponent(String className) {
        if (this.extensionManager.isSplitActivity(className)) {
            return FakeActivity.class;
        }
        if (this.extensionManager.isSplitService(className)) {
            return FakeService.class;
        }
        if (this.extensionManager.isSplitReceiver(className)) {
            return FakeReceiver.class;
        }
        return null;
    }

    public String getSplitNameForActivityName(@NonNull String activityClassName) {
        String ret = null;
        Map<String, List<String>> splitActivitiesMap = this.extensionManager.getSplitActivitiesMap();
        for (Map.Entry<String, List<String>> entry : splitActivitiesMap.entrySet()) {
            String splitName = entry.getKey();
            List<String> activities = entry.getValue();
            if (activities == null || !activities.contains(activityClassName)) continue;
            ret = splitName;
            break;
        }
        return ret;
    }

    private Set<String> getSplitNames() {
        String[] dynamicFeatures = SplitBaseInfoProvider.getDynamicFeatures();
        HashSet<String> modules = new HashSet<String>();
        if (dynamicFeatures != null && dynamicFeatures.length > 0) {
            modules.addAll(Arrays.asList(dynamicFeatures));
        }
        return modules;
    }
}

