/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.extension;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionException;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionManager;
import com.iqiyi.android.qigsaw.core.extension.SplitComponentInfoProvider;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class AABExtensionManagerImpl
implements AABExtensionManager {
    private static final String TAG = "Split:AABExtensionManagerImpl";
    private final Context context;
    private SplitComponentInfoProvider infoProvider;
    @Nullable
    private Object activityThread;
    private List<String> splitActivities;
    private List<String> splitServices;
    private List<String> splitReceivers;

    AABExtensionManagerImpl(Context context, SplitComponentInfoProvider infoProvider) {
        this.context = context;
        this.activityThread = this.getActivityThread();
        this.infoProvider = infoProvider;
    }

    @Override
    public Map<String, List<ProviderInfo>> removeSplitProviders(Set<String> unLoadSplits) throws AABExtensionException {
        ReflectiveOperationException error;
        try {
            return this.removeSplitProvidersInternal(unLoadSplits);
        }
        catch (IllegalAccessException e) {
            error = e;
        }
        catch (NoSuchFieldException e) {
            error = e;
        }
        throw new AABExtensionException(error);
    }

    @Override
    public void installSplitProviders(List<ProviderInfo> providers) throws AABExtensionException {
        ReflectiveOperationException error = null;
        try {
            this.installSplitProvidersInternal(providers);
        }
        catch (NoSuchFieldException e) {
            error = e;
        }
        catch (IllegalAccessException e) {
            error = e;
        }
        catch (NoSuchMethodException e) {
            error = e;
        }
        catch (InvocationTargetException e) {
            error = e;
        }
        if (error != null) {
            throw new AABExtensionException(error);
        }
    }

    @Override
    @SuppressLint(value={"PrivateApi"})
    public Application createApplication(String splitName) throws AABExtensionException {
        ReflectiveOperationException error = null;
        String applicationName = this.infoProvider.getSplitApplicationName(splitName);
        if (!TextUtils.isEmpty((CharSequence)applicationName)) {
            try {
                Class<?> appClass = this.context.getClassLoader().loadClass(applicationName);
                return (Application)appClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                error = e;
            }
            catch (InstantiationException e) {
                error = e;
            }
            catch (IllegalAccessException e) {
                error = e;
            }
        }
        if (error != null) {
            throw new AABExtensionException(error);
        }
        return null;
    }

    @Override
    @SuppressLint(value={"PrivateApi"})
    public void activeApplication(Application app) throws AABExtensionException {
        if (app != null) {
            ReflectiveOperationException error = null;
            try {
                Method method = Application.class.getDeclaredMethod("attach", Context.class);
                method.setAccessible(true);
                method.invoke((Object)app, this.context);
            }
            catch (NoSuchMethodException e) {
                error = e;
            }
            catch (IllegalAccessException e) {
                error = e;
            }
            catch (InvocationTargetException e) {
                error = e;
            }
            if (error != null) {
                throw new AABExtensionException(error);
            }
        }
    }

    @Override
    public boolean isSplitActivities(String name) {
        if (this.getSplitActivities() != null) {
            return this.getSplitActivities().contains(name);
        }
        return false;
    }

    @Override
    public boolean isSplitServices(String name) {
        if (this.getSplitServices() != null) {
            return this.getSplitServices().contains(name);
        }
        return false;
    }

    @Override
    public boolean isSplitReceivers(String name) {
        if (this.getSplitReceivers() != null) {
            return this.getSplitReceivers().contains(name);
        }
        return false;
    }

    @SuppressLint(value={"PrivateApi"})
    private Object getActivityThread() {
        try {
            Class<?> atClass = Class.forName("android.app.ActivityThread");
            Method method = atClass.getDeclaredMethod("currentActivityThread", new Class[0]);
            method.setAccessible(true);
            return method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Map<String, List<ProviderInfo>> removeSplitProvidersInternal(Set<String> unLoadSplits) throws NoSuchFieldException, IllegalAccessException {
        if (!unLoadSplits.isEmpty()) {
            HashMap<String, List<ProviderInfo>> unloadSplitProvidersMap = new HashMap<String, List<ProviderInfo>>();
            Map<String, List<String>> providerMap = this.infoProvider.getSplitProviders();
            for (String name : unLoadSplits) {
                List<String> splitProviders = providerMap.get(name);
                if (splitProviders == null || splitProviders.isEmpty()) continue;
                List<ProviderInfo> providerInfos = this.removeSplitProvidersForApp(splitProviders);
                unloadSplitProvidersMap.put(name, providerInfos);
                SplitLog.i((String)TAG, (String)"Success to remove providers for %s", (Object[])new Object[]{name});
            }
            return unloadSplitProvidersMap;
        }
        return null;
    }

    private void installSplitProvidersInternal(List<ProviderInfo> providers) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (providers != null && !providers.isEmpty()) {
            List<ProviderInfo> appProviders = this.getAppProviders();
            if (this.activityThread != null && appProviders != null) {
                Method method = this.activityThread.getClass().getDeclaredMethod("installContentProviders", Context.class, List.class);
                method.setAccessible(true);
                method.invoke(this.activityThread, this.context, providers);
                appProviders.addAll(providers);
            }
        }
    }

    private List<ProviderInfo> removeSplitProvidersForApp(List<String> splitProviderNames) throws NoSuchFieldException, IllegalAccessException {
        List<ProviderInfo> appProviders = this.getAppProviders();
        if (appProviders != null && !appProviders.isEmpty()) {
            ArrayList<ProviderInfo> splitProviders = new ArrayList<ProviderInfo>();
            block0: for (String providerName : splitProviderNames) {
                for (ProviderInfo info : appProviders) {
                    if (!providerName.equals(info.name)) continue;
                    splitProviders.add(info);
                    appProviders.remove(info);
                    SplitLog.i((String)TAG, (String)"Provider %s removed successfully", (Object[])new Object[]{info.name});
                    continue block0;
                }
            }
            return splitProviders;
        }
        return null;
    }

    private List<ProviderInfo> getAppProviders() throws NoSuchFieldException, IllegalAccessException {
        if (this.activityThread != null) {
            Field boundApplicationField = this.activityThread.getClass().getDeclaredField("mBoundApplication");
            boundApplicationField.setAccessible(true);
            Object boundApplication = boundApplicationField.get(this.activityThread);
            Field providersField = boundApplication.getClass().getDeclaredField("providers");
            providersField.setAccessible(true);
            return (List)providersField.get(boundApplication);
        }
        SplitLog.w((String)TAG, (String)"Failed to get ActivityThread instance!", (Object[])new Object[0]);
        return null;
    }

    private List<String> getSplitActivities() {
        if (this.splitActivities == null) {
            this.splitActivities = this.infoProvider.getSplitActivities();
        }
        return this.splitActivities;
    }

    private List<String> getSplitServices() {
        if (this.splitServices == null) {
            this.splitServices = this.infoProvider.getSplitServices();
        }
        return this.splitServices;
    }

    private List<String> getSplitReceivers() {
        if (this.splitReceivers == null) {
            this.splitReceivers = this.infoProvider.getSplitReceivers();
        }
        return this.splitReceivers;
    }
}

