/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.extension;

import android.app.Application;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.v4.util.ArraySet;
import com.iqiyi.android.qigsaw.core.common.SplitBaseInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionException;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionManager;
import com.iqiyi.android.qigsaw.core.extension.AABExtensionManagerImpl;
import com.iqiyi.android.qigsaw.core.extension.SplitComponentInfoProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AABExtension {
    private static final String TAG = "Split:AABExtension";
    private static final AtomicReference<AABExtension> sAABCompatReference = new AtomicReference<Object>(null);
    private final Map<String, List<ProviderInfo>> splitProviders = new HashMap<String, List<ProviderInfo>>();
    private final List<Application> splitApplications = new ArrayList<Application>();
    private final AABExtensionManager extensionManager;
    private final Set<String> splitNames = this.getSplitNames();

    private AABExtension(Context context) {
        this.extensionManager = new AABExtensionManagerImpl(context, new SplitComponentInfoProvider(this.splitNames));
    }

    public static void install(Context context) {
        sAABCompatReference.compareAndSet(null, new AABExtension(context));
    }

    public static AABExtension getInstance() {
        if (sAABCompatReference.get() == null) {
            throw new RuntimeException("Have you invoke AABCompat#install(Context) method?");
        }
        return sAABCompatReference.get();
    }

    public void onBaseContextAttached(@NonNull Set<String> loadedSplits) {
        Set<String> unloadSplits = this.getUnloadSplits(loadedSplits);
        try {
            Map<String, List<ProviderInfo>> providers = this.extensionManager.removeSplitProviders(unloadSplits);
            if (providers != null && !providers.isEmpty()) {
                this.splitProviders.putAll(providers);
            }
        }
        catch (Exception e) {
            SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to remove providers", (Object[])new Object[0]);
        }
        if (!loadedSplits.isEmpty()) {
            for (String splitName : loadedSplits) {
                try {
                    Application app = this.createApplication(splitName);
                    if (app == null) continue;
                    this.splitApplications.add(app);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void onCreate() {
        for (Application application : this.splitApplications) {
            application.onCreate();
        }
    }

    public Application createApplication(String splitName) throws AABExtensionException {
        Application app = this.extensionManager.createApplication(splitName);
        this.extensionManager.activeApplication(app);
        return app;
    }

    public boolean isSplitActivities(String name) {
        return this.extensionManager.isSplitActivities(name);
    }

    public boolean isSplitServices(String name) {
        return this.extensionManager.isSplitServices(name);
    }

    public boolean isSplitReceivers(String name) {
        return this.extensionManager.isSplitReceivers(name);
    }

    public boolean isSplitComponents(String name) {
        if (this.extensionManager.isSplitActivities(name)) {
            return true;
        }
        if (this.extensionManager.isSplitServices(name)) {
            return true;
        }
        return this.extensionManager.isSplitReceivers(name);
    }

    public void installSplitProviders(String moduleName) throws AABExtensionException {
        List<ProviderInfo> providers = this.splitProviders.get(moduleName);
        this.extensionManager.installSplitProviders(providers);
        this.splitProviders.remove(moduleName);
    }

    private Set<String> getSplitNames() {
        String[] dynamicFeatures = SplitBaseInfoProvider.getDynamicFeatures();
        HashSet<String> modules = new HashSet<String>();
        if (dynamicFeatures != null && dynamicFeatures.length > 0) {
            modules.addAll(Arrays.asList(dynamicFeatures));
        }
        return modules;
    }

    private Set<String> getUnloadSplits(Set<String> loadedSplits) {
        ArraySet unloadSplits = new ArraySet();
        if (!this.splitNames.isEmpty()) {
            for (String name : this.splitNames) {
                if (loadedSplits.contains(name)) continue;
                unloadSplits.add(name);
            }
        }
        return unloadSplits;
    }
}

