/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.common;

import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.FileLockHelper;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.zip.ZipFile;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FileUtil {
    private static final String TAG = "Split.FileUtil";

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream input, OutputStream output) throws IOException {
        BufferedInputStream bufferedInput = new BufferedInputStream(input);
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
        try {
            byte[] buffer = new byte[16384];
            int length = bufferedInput.read(buffer);
            while (length != -1) {
                bufferedOutput.write(buffer, 0, length);
                length = bufferedInput.read(buffer);
            }
            bufferedOutput.flush();
        }
        finally {
            FileUtil.closeQuietly(input);
            FileUtil.closeQuietly(output);
        }
    }

    public static void createFileSafely(@NonNull File file) throws IOException {
        if (!file.exists()) {
            boolean isCreationSuccessful = false;
            int numAttempts = 0;
            Exception cause = null;
            while (numAttempts < 3 && !isCreationSuccessful) {
                ++numAttempts;
                try {
                    if (!file.createNewFile()) {
                        SplitLog.w(TAG, "File %s already exists", file.getAbsolutePath());
                    }
                    isCreationSuccessful = true;
                }
                catch (Exception e) {
                    isCreationSuccessful = false;
                    cause = e;
                }
            }
            if (!isCreationSuccessful) {
                throw new IOException("Failed to create file " + file.getAbsolutePath(), cause);
            }
            SplitLog.v(TAG, "Succeed to create file " + file.getAbsolutePath(), new Object[0]);
        }
    }

    public static synchronized boolean deleteFileSafelyLock(@NonNull File file, File lockFile) throws IOException {
        boolean ret;
        if (!file.exists()) {
            return true;
        }
        FileLockHelper fileLock = null;
        try {
            fileLock = FileLockHelper.getFileLock(lockFile);
            ret = FileUtil.deleteFileSafely(file);
        }
        catch (IOException e) {
            throw new IOException("Failed to lock file " + lockFile.getAbsolutePath());
        }
        finally {
            if (lockFile != null) {
                FileUtil.closeQuietly(fileLock);
            }
        }
        return ret;
    }

    public static synchronized void createFileSafelyLock(@NonNull File file, File lockFile) throws IOException {
        if (file.exists()) {
            return;
        }
        FileLockHelper fileLock = null;
        try {
            fileLock = FileLockHelper.getFileLock(lockFile);
            try {
                FileUtil.createFileSafely(file);
            }
            catch (IOException e) {
                throw new IOException("Failed to create file " + file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to lock file " + lockFile.getAbsolutePath());
        }
        finally {
            if (lockFile != null) {
                FileUtil.closeQuietly(fileLock);
            }
        }
    }

    public static boolean deleteFileSafely(@NonNull File file) {
        if (!file.exists()) {
            return true;
        }
        boolean isDeleteSuccessful = false;
        for (int numAttempts = 0; numAttempts < 3 && !isDeleteSuccessful; ++numAttempts) {
            if (!file.delete()) continue;
            isDeleteSuccessful = true;
        }
        SplitLog.d(TAG, "%s to delete file: " + file.getAbsolutePath(), isDeleteSuccessful ? "Succeed" : "Failed");
        return isDeleteSuccessful;
    }

    public static void copyFile(File source, File dest) throws IOException {
        FileUtil.copyFile(new FileInputStream(source), new FileOutputStream(dest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) {
        String string;
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            string = FileUtil.getMD5(fin);
        }
        catch (Exception e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly(fin);
                throw throwable;
            }
            FileUtil.closeQuietly(fin);
            return string2;
        }
        FileUtil.closeQuietly(fin);
        return string;
    }

    public static String getMD5(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            int readCount;
            BufferedInputStream bis = new BufferedInputStream(is);
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuilder md5Str = new StringBuilder(32);
            byte[] buf = new byte[102400];
            while ((readCount = bis.read(buf)) != -1) {
                md.update(buf, 0, readCount);
            }
            byte[] hashValue = md.digest();
            for (int i = 0; i < hashValue.length; ++i) {
                md5Str.append(Integer.toString((hashValue[i] & 0xFF) + 256, 16).substring(1));
            }
            return md5Str.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void closeQuietly(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (Throwable throwable) {}
        } else if (Build.VERSION.SDK_INT >= 19 && obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Throwable throwable) {}
        } else if (obj instanceof ZipFile) {
            try {
                ((ZipFile)obj).close();
            }
            catch (Throwable throwable) {}
        } else {
            throw new IllegalArgumentException("obj: " + obj + " cannot be closed.");
        }
    }

    public static boolean isLegalFile(File file) {
        return file != null && file.exists() && file.canRead() && file.isFile() && file.length() > 0L;
    }

    public static boolean deleteDir(File file) {
        return FileUtil.deleteDir(file, true);
    }

    public static boolean deleteDir(File file, boolean deleteRootDir) {
        File[] files;
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isFile()) {
            FileUtil.deleteFileSafely(file);
        } else if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File subFile : files) {
                FileUtil.deleteDir(subFile);
            }
            if (deleteRootDir) {
                FileUtil.deleteFileSafely(file);
            }
        }
        return true;
    }
}

