/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.common;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import java.util.Arrays;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AbiUtil {
    private static final String armv5 = "armeabi";
    private static final String armv7 = "armeabi-v7a";
    private static final String armv8 = "arm64-v8a";
    private static final String x86 = "x86";
    private static final String x86_64 = "x86_64";
    private static List<String> abis;

    private static List<String> getSupportedAbis() {
        if (abis != null) {
            return abis;
        }
        abis = Build.VERSION.SDK_INT >= 21 ? Arrays.asList(Build.SUPPORTED_ABIS) : Arrays.asList(Build.CPU_ABI, Build.CPU_ABI2);
        return abis;
    }

    public static String findBasePrimaryAbi(@Nullable List<String> baseAbis) {
        List<String> supportedAbis = AbiUtil.getSupportedAbis();
        if (baseAbis == null) {
            return supportedAbis.get(0);
        }
        for (String abi : supportedAbis) {
            if (!baseAbis.contains(abi)) continue;
            return abi;
        }
        throw new RuntimeException("No supported abi for this device.");
    }

    public static String findSplitPrimaryAbi(@NonNull String basePrimaryAbi, @NonNull List<String> splitAbis) {
        if (splitAbis.contains(basePrimaryAbi)) {
            return basePrimaryAbi;
        }
        if (basePrimaryAbi.contains(armv8)) {
            return splitAbis.contains(armv8) ? armv8 : null;
        }
        if (basePrimaryAbi.contains(x86_64)) {
            return splitAbis.contains(x86_64) ? x86_64 : null;
        }
        if (basePrimaryAbi.contains(x86)) {
            if (splitAbis.contains(x86)) {
                return x86;
            }
            if (splitAbis.contains(armv5)) {
                return armv5;
            }
        } else if (basePrimaryAbi.contains(armv7)) {
            if (splitAbis.contains(armv7)) {
                return armv7;
            }
            if (splitAbis.contains(armv5)) {
                return armv5;
            }
        } else if (basePrimaryAbi.contains(armv5)) {
            if (splitAbis.contains(armv5)) {
                return armv5;
            }
            List<String> supportedAbis = AbiUtil.getSupportedAbis();
            if (supportedAbis.contains(armv7) && splitAbis.contains(armv7)) {
                return armv7;
            }
        }
        return null;
    }
}

