/*
 * Decompiled with CFR 0.152.
 */
package ioinformarics.oss.jackson.module.jsonld.internal;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldLink;
import ioinformarics.oss.jackson.module.jsonld.util.JsonldResourceUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class JsonldResourceSerializer
extends BeanSerializer {
    public JsonldResourceSerializer(BeanSerializerBase src) {
        super(src);
    }

    protected void serializeFields(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        Optional<ObjectNode> context;
        Optional<String> type = JsonldResourceUtils.dynamicTypeLookup(bean.getClass());
        if (type.isPresent()) {
            jgen.writeStringField("@type", type.get());
        }
        if ((context = JsonldResourceUtils.getContext(bean)).isPresent()) {
            jgen.writeObjectField("@context", (Object)context.get());
        }
        super.serializeFields(bean, jgen, provider);
        this.getLinks(bean).ifPresent(linksMap -> linksMap.forEach((key, value) -> {
            try {
                jgen.writeStringField(key, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    protected Optional<Map<String, String>> getLinks(Object resource) {
        HashMap<String, String> linksNodes = null;
        Class<?> beanType = resource.getClass();
        JsonldLink[] links = (JsonldLink[])beanType.getAnnotationsByType(JsonldLink.class);
        if (links != null) {
            linksNodes = new HashMap<String, String>(links.length);
            for (int i = 0; i < links.length; ++i) {
                linksNodes.put(links[i].name(), links[i].href());
            }
        }
        return Optional.ofNullable(linksNodes);
    }
}

