/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.jwt.hmac;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.primeframework.jwt.Verifier;
import org.primeframework.jwt.domain.Algorithm;
import org.primeframework.jwt.domain.InvalidJWTSignatureException;

public class HMACVerifier
implements Verifier {
    private final byte[] secret;

    private HMACVerifier(String secret) {
        Objects.requireNonNull(secret);
        this.secret = secret.getBytes();
    }

    public static HMACVerifier newVerifier(String secret) {
        return new HMACVerifier(secret);
    }

    @Override
    public boolean canVerify(Algorithm algorithm) {
        switch (algorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void verify(Algorithm algorithm, byte[] payload, byte[] signature) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(payload);
        Objects.requireNonNull(signature);
        try {
            Mac mac = Mac.getInstance(algorithm.getName());
            mac.init(new SecretKeySpec(this.secret, algorithm.getName()));
            byte[] actualSignature = mac.doFinal(payload);
            if (!Arrays.equals(signature, actualSignature)) {
                throw new InvalidJWTSignatureException();
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

