/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.oauth2.data;

import com.intuit.oauth2.config.Environment;
import com.intuit.oauth2.config.OAuth2Config;
import com.intuit.oauth2.config.Scope;

public class OAuthMigrationRequest {
    private Environment environment;
    private OAuth2Config oauth2config;
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String accessSecret;
    private Scope scope;
    private String redirectUri;

    private OAuthMigrationRequest(OAuthMigrationRequestBuilder builder) {
        this.environment = builder.environment;
        this.oauth2config = builder.oauth2config;
        this.consumerKey = builder.consumerKey;
        this.consumerSecret = builder.consumerSecret;
        this.accessToken = builder.accessToken;
        this.accessSecret = builder.accessSecret;
        this.scope = builder.scope;
        this.redirectUri = builder.redirectUri;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public OAuth2Config getOauth2config() {
        return this.oauth2config;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public static class OAuthMigrationRequestBuilder {
        private Environment environment;
        private OAuth2Config oauth2config;
        private String consumerKey;
        private String consumerSecret;
        private String accessToken;
        private String accessSecret;
        private Scope scope;
        private String redirectUri;

        public OAuthMigrationRequestBuilder(Environment environment, Scope scope) {
            this.environment = environment;
            this.scope = scope;
        }

        public OAuthMigrationRequestBuilder consumerKey(String consumerKey) {
            this.consumerKey = consumerKey;
            return this;
        }

        public OAuthMigrationRequestBuilder consumerSecret(String consumerSecret) {
            this.consumerSecret = consumerSecret;
            return this;
        }

        public OAuthMigrationRequestBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public OAuthMigrationRequestBuilder accessSecret(String accessSecret) {
            this.accessSecret = accessSecret;
            return this;
        }

        public OAuthMigrationRequestBuilder oAuth2Config(OAuth2Config oAuth2Config) {
            this.oauth2config = oAuth2Config;
            return this;
        }

        public OAuthMigrationRequestBuilder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public OAuthMigrationRequest build() {
            return new OAuthMigrationRequest(this);
        }
    }
}

