/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.oauth2.utils;

import com.intuit.oauth2.utils.LoggerImpl;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;

public class PropertiesConfig {
    protected Logger logger = LoggerImpl.getInstance();
    private static Properties prop = new Properties();
    private static PropertiesConfig config = null;
    private static final String PROP_FILE_NAME = "oauthclient.properties";

    private PropertiesConfig() {
    }

    public static synchronized PropertiesConfig getInstance() {
        if (config == null) {
            config = new PropertiesConfig();
            config.readProperties();
        }
        return config;
    }

    private void readProperties() {
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream(PROP_FILE_NAME);
            if (input == null) {
                this.logger.info("Unnable to find oauthclient.properties");
                return;
            }
            prop.load(input);
        }
        catch (Exception e) {
            this.logger.info("exception in PropertiesConfig readProperties");
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {
                    this.logger.info("exception in PropertiesConfig readProperties finally");
                }
            }
        }
    }

    public String getProperty(String key) {
        return prop.getProperty(key);
    }
}

