/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.util;

import com.intuit.ipp.util.Logger;
import com.intuit.ipp.util.StringUtils;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.XMLConfiguration;

public final class Config {
    private static final org.slf4j.Logger LOG = Logger.getLogger();
    private CompositeConfiguration cc = null;
    public static final String BASE_URL_QB_API = "baseURL.quickbooks-api";
    public static final String BASE_URL_QBO = "baseURL.qbo";
    public static final String BASE_URL_PLATFORMSERVICE = "baseURL.platformService";
    public static final String BASE_URL_ENTITLEMENTSERVICE = "baseURL.entitlementService";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";
    public static final String PROXY_USERNAME = "proxy.username";
    public static final String PROXY_PASSWORD = "proxy.password";
    public static final String PROXY_DOMAIN = "proxy.domain";
    public static final String PROXY_KEYSTORE_PATH = "proxy.keystore.path";
    public static final String PROXY_KEYSTORE_PASSWORD = "proxy.keystore.password";
    public static final String RETRY_MODE = "retry.mode";
    public static final String RETRY_FIXED_COUNT = "retry.fixed.count";
    public static final String RETRY_FIXED_INTERVAL = "retry.fixed.interval";
    public static final String RETRY_INCREMENTAL_COUNT = "retry.incremental.count";
    public static final String RETRY_INCREMENTAL_INTERVAL = "retry.incremental.interval";
    public static final String RETRY_INCREMENTAL_INCREMENT = "retry.incremental.increment";
    public static final String RETRY_EXPONENTIAL_COUNT = "retry.exponential.count";
    public static final String RETRY_EXPONENTIAL_MIN_BACKOFF = "retry.exponential.minBackoff";
    public static final String RETRY_EXPONENTIAL_MAX_BACKOFF = "retry.exponential.maxBackoff";
    public static final String RETRY_EXPONENTIAL_DELTA_BACKOFF = "retry.exponential.deltaBackoff";
    public static final String COMPRESSION_REQUEST_FORMAT = "message.request.compression";
    public static final String COMPRESSION_RESPONSE_FORMAT = "message.response.compression";
    public static final String SERIALIZATION_REQUEST_FORMAT = "message.request.serialization";
    public static final String SERIALIZATION_RESPONSE_FORMAT = "message.response.serialization";
    public static final String TIMEOUT_CONNECTION = "timeout.connectionTimeout";
    public static final String TIMEOUT_REQUEST = "timeout.requestTimeout";
    public static final String ENVIRONMENT_VAR_QBO_BASE_URL = "IPP_QBO_BASE_URL";
    public static final String HTTP_TRANSPORT = "httpTransport";
    public static final String TLS_VERSION = "tls.version";
    public static final String BIGDECIMAL_SCALE_SHIFT = "feature.bigDecimalScaleShift";
    public static final String WEBHOOKS_VERIFIER_TOKEN = "webhooks.verifier.token";
    public static final String LATEST_MINOR_VERSION = "minorVersion.latestMinorVersion";
    private static ThreadLocal<Config> local = new ThreadLocal<Config>(){

        @Override
        public Config initialValue() {
            return new Config();
        }

        @Override
        public Config get() {
            return (Config)super.get();
        }
    };

    private Config() {
        try {
            XMLConfiguration config = null;
            XMLConfiguration devConfig = null;
            this.cc = new CompositeConfiguration();
            try {
                devConfig = new XMLConfiguration("intuit-config.xml");
                this.cc.addConfiguration((Configuration)devConfig);
            }
            catch (ConfigurationException e) {
                LOG.warn("issue reading config.xml");
                LOG.debug("issue reading config.xml");
            }
            config = new XMLConfiguration("intuit-default-config.xml");
            this.cc.addConfiguration((Configuration)config);
            try {
                EnvironmentConfiguration envConfig = new EnvironmentConfiguration();
                String envQBOBaseUrl = envConfig.getString(ENVIRONMENT_VAR_QBO_BASE_URL);
                if (StringUtils.hasText(envQBOBaseUrl)) {
                    this.cc.setProperty(BASE_URL_QBO, (Object)envQBOBaseUrl);
                }
            }
            catch (Exception e) {
                LOG.warn("ConfigurationException while reading environment configuration.", (Throwable)e);
            }
        }
        catch (ConfigurationException e) {
            LOG.error("ConfigurationException while loading configuration xml file.", (Throwable)e);
        }
    }

    public static String getProperty(String key) {
        return Config.local.get().cc.getString(key);
    }

    public static void setProperty(String key, String value) {
        Config.local.get().cc.setProperty(key, (Object)value);
    }

    public static Boolean getBooleanProperty(String key) {
        return Config.getBooleanProperty(key, null);
    }

    public static Boolean getBooleanProperty(String key, Boolean defaultValue) {
        String value = Config.getProperty(key);
        if (null == value || value.isEmpty()) {
            return null == defaultValue ? false : defaultValue;
        }
        if ("null".equals(value.toLowerCase()) && null != defaultValue) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static Configuration cloneConfigurationOverrides() {
        return ConfigurationUtils.cloneConfiguration((Configuration)Config.local.get().cc.getInMemoryConfiguration());
    }

    public static void addConfigurationOverrides(Configuration configuration) {
        ConfigurationUtils.copy((Configuration)configuration, (Configuration)Config.local.get().cc);
    }
}

