/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.services;

import com.intuit.ipp.core.Context;
import com.intuit.ipp.data.IntuitResponse;
import com.intuit.ipp.data.Report;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.IntuitInterceptorProvider;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.RequestElements;
import com.intuit.ipp.net.MethodType;
import com.intuit.ipp.net.OperationType;
import java.util.Map;

public class ReportService {
    private transient Context context = null;
    private String report_date = null;
    private String start_date = null;
    private String end_date = null;
    private String date_macro = null;
    private String past_due = null;
    private String end_duedate = null;
    private String start_duedate = null;
    private String duedate_macro = null;
    private String accounting_method = null;
    private String account = null;
    private String source_account = null;
    private String account_type = null;
    private String source_account_type = null;
    private String summarize_column_by = null;
    private String customer = null;
    private String vendor = null;
    private String item = null;
    private String classid = null;
    private String appaid = null;
    private String department = null;
    private String qzurl = null;
    private String aging_period = null;
    private String aging_method = null;
    private String num_periods = null;
    private String term = null;
    private String columns = null;
    private String sort_by = null;
    private String sort_order = null;
    private String group_by = null;
    private String createdate_macro = null;
    private String end_createdate = null;
    private String start_createdate = null;
    private String moddate_macro = null;
    private String end_moddate = null;
    private String start_moddate = null;
    private String payment_method = null;
    private String name = null;
    private String transaction_type = null;
    private String cleared = null;
    private String arpaid = null;
    private String printed = null;
    private String both_amount = null;
    private String memo = null;
    private String doc_num = null;
    private String journal_code = null;
    private String employee = null;
    private String agency_id = null;
    private String custom1 = null;
    private String custom2 = null;
    private String custom3 = null;
    private String shipvia = null;
    private String account_status = null;
    private String subcol_pct_inc = null;
    private String subcol_pct_exp = null;

    protected ReportService() {
    }

    public ReportService(Context context) {
        this.context = context;
    }

    public Report executeReport(String reportName) throws FMSException {
        IntuitMessage intuitMessage = this.prepareReport(reportName);
        this.executeInterceptors(intuitMessage);
        Report report = null;
        IntuitResponse intuitResponse = (IntuitResponse)intuitMessage.getResponseElements().getResponse();
        if (intuitResponse != null) {
            report = intuitResponse.getReport();
        }
        return report;
    }

    protected void executeInterceptors(IntuitMessage intuitMessage) throws FMSException {
        new IntuitInterceptorProvider().executeInterceptors(intuitMessage);
    }

    private IntuitMessage prepareReport(String reportName) throws FMSException {
        IntuitMessage intuitMessage = new IntuitMessage();
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        requestParameters.put("method_type", MethodType.GET.toString());
        if (this.getReport_date() != null) {
            requestParameters.put("report_date", this.getReport_date());
        }
        if (this.getStart_date() != null) {
            requestParameters.put("start_date", this.getStart_date());
        }
        if (this.getEnd_date() != null) {
            requestParameters.put("end_date", this.getEnd_date());
        }
        if (this.getDate_macro() != null) {
            requestParameters.put("date_macro", this.getDate_macro());
        }
        if (this.getPast_due() != null) {
            requestParameters.put("past_due", this.getPast_due());
        }
        if (this.getStart_duedate() != null) {
            requestParameters.put("start_duedate", this.getStart_duedate());
        }
        if (this.getEnd_duedate() != null) {
            requestParameters.put("end_duedate", this.getEnd_duedate());
        }
        if (this.getDuedate_macro() != null) {
            requestParameters.put("duedate_macro", this.getDuedate_macro());
        }
        if (this.getAccounting_method() != null) {
            requestParameters.put("accounting_method", this.getAccounting_method());
        }
        if (this.getAccount() != null) {
            requestParameters.put("account", this.getAccount());
        }
        if (this.getSource_account() != null) {
            requestParameters.put("source_account", this.getSource_account());
        }
        if (this.getAccount_type() != null) {
            requestParameters.put("account_type", this.getAccount_type());
        }
        if (this.getSource_account_type() != null) {
            requestParameters.put("source_account_type", this.getSource_account_type());
        }
        if (this.getSummarize_column_by() != null) {
            requestParameters.put("summarize_column_by", this.getSummarize_column_by());
        }
        if (this.getCustomer() != null) {
            requestParameters.put("customer", this.getCustomer());
        }
        if (this.getVendor() != null) {
            requestParameters.put("vendor", this.getVendor());
        }
        if (this.getItem() != null) {
            requestParameters.put("item", this.getItem());
        }
        if (this.getClassid() != null) {
            requestParameters.put("class", this.getClassid());
        }
        if (this.getAppaid() != null) {
            requestParameters.put("appaid", this.getAppaid());
        }
        if (this.getDepartment() != null) {
            requestParameters.put("department", this.getDepartment());
        }
        if (this.getQzurl() != null) {
            requestParameters.put("qzurl", this.getQzurl());
        }
        if (this.getAging_period() != null) {
            requestParameters.put("aging_period", this.getAging_period());
        }
        if (this.getAging_method() != null) {
            requestParameters.put("aging_method", this.getAging_method());
        }
        if (this.getNum_periods() != null) {
            requestParameters.put("num_periods", this.getNum_periods());
        }
        if (this.getTerm() != null) {
            requestParameters.put("term", this.getTerm());
        }
        if (this.getColumns() != null) {
            requestParameters.put("columns", this.getColumns());
        }
        if (this.getSort_by() != null) {
            requestParameters.put("sort_by", this.getSort_by());
        }
        if (this.getSort_order() != null) {
            requestParameters.put("sort_order", this.getSort_order());
        }
        if (this.getGroup_by() != null) {
            requestParameters.put("group_by", this.getGroup_by());
        }
        if (this.getCreatedate_macro() != null) {
            requestParameters.put("createdate_macro", this.getCreatedate_macro());
        }
        if (this.getEnd_createdate() != null) {
            requestParameters.put("end_createdate", this.getEnd_createdate());
        }
        if (this.getStart_createdate() != null) {
            requestParameters.put("start_createdate", this.getStart_createdate());
        }
        if (this.getModdate_macro() != null) {
            requestParameters.put("moddate_macro", this.getModdate_macro());
        }
        if (this.getEnd_moddate() != null) {
            requestParameters.put("end_moddate", this.getEnd_moddate());
        }
        if (this.getStart_moddate() != null) {
            requestParameters.put("start_moddate", this.getStart_moddate());
        }
        if (this.getPayment_method() != null) {
            requestParameters.put("payment_method", this.getPayment_method());
        }
        if (this.getName() != null) {
            requestParameters.put("name", this.getName());
        }
        if (this.getTransaction_type() != null) {
            requestParameters.put("transaction_type", this.getTransaction_type());
        }
        if (this.getCleared() != null) {
            requestParameters.put("cleared", this.getCleared());
        }
        if (this.getArpaid() != null) {
            requestParameters.put("arpaid", this.getArpaid());
        }
        if (this.getPrinted() != null) {
            requestParameters.put("printed", this.getPrinted());
        }
        if (this.getBoth_amount() != null) {
            requestParameters.put("bothamount", this.getBoth_amount());
        }
        if (this.getMemo() != null) {
            requestParameters.put("memo", this.getMemo());
        }
        if (this.getDoc_num() != null) {
            requestParameters.put("docnum", this.getDoc_num());
        }
        if (this.getJournal_code() != null) {
            requestParameters.put("journal_code", this.getJournal_code());
        }
        if (this.getEmployee() != null) {
            requestParameters.put("employee", this.getEmployee());
        }
        if (this.getAgency_id() != null) {
            requestParameters.put("agency_id", this.getAgency_id());
        }
        if (this.getCustom1() != null) {
            requestParameters.put("custom1", this.getCustom1());
        }
        if (this.getCustom2() != null) {
            requestParameters.put("custom2", this.getCustom2());
        }
        if (this.getCustom3() != null) {
            requestParameters.put("custom3", this.getCustom3());
        }
        if (this.getShipvia() != null) {
            requestParameters.put("shipvia", this.getShipvia());
        }
        if (this.getAccount_status() != null) {
            requestParameters.put("account_status", this.getAccount_status());
        }
        if (this.getSubcol_pct_inc() != null) {
            requestParameters.put("subcol_pct_inc", this.getSubcol_pct_inc());
        }
        if (this.getSubcol_pct_exp() != null) {
            requestParameters.put("subcol_pct_exp", this.getSubcol_pct_exp());
        }
        requestElements.setAction(OperationType.REPORTS.toString() + "/" + reportName);
        requestElements.setContext(this.context);
        return intuitMessage;
    }

    public String getReport_date() {
        return this.report_date;
    }

    public void setReport_date(String report_date) {
        this.report_date = report_date;
    }

    public String getStart_date() {
        return this.start_date;
    }

    public void setStart_date(String start_date) {
        this.start_date = start_date;
    }

    public String getEnd_date() {
        return this.end_date;
    }

    public void setEnd_date(String end_date) {
        this.end_date = end_date;
    }

    public String getDate_macro() {
        return this.date_macro;
    }

    public void setDate_macro(String date_macro) {
        this.date_macro = date_macro;
    }

    public String getAccounting_method() {
        return this.accounting_method;
    }

    public void setAccounting_method(String accounting_method) {
        this.accounting_method = accounting_method;
    }

    public String getSummarize_column_by() {
        return this.summarize_column_by;
    }

    public void setSummarize_column_by(String summarize_column_by) {
        this.summarize_column_by = summarize_column_by;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getItem() {
        return this.item;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public String getClassid() {
        return this.classid;
    }

    public void setClassid(String classid) {
        this.classid = classid;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getQzurl() {
        return this.qzurl;
    }

    public void setQzurl(String qzurl) {
        this.qzurl = qzurl;
    }

    public String getAging_period() {
        return this.aging_period;
    }

    public void setAging_period(String aging_period) {
        this.aging_period = aging_period;
    }

    public String getNum_periods() {
        return this.num_periods;
    }

    public void setNum_periods(String num_periods) {
        this.num_periods = num_periods;
    }

    public String getPast_due() {
        return this.past_due;
    }

    public void setPast_due(String past_due) {
        this.past_due = past_due;
    }

    public String getEnd_duedate() {
        return this.end_duedate;
    }

    public void setEnd_duedate(String end_duedate) {
        this.end_duedate = end_duedate;
    }

    public String getStart_duedate() {
        return this.start_duedate;
    }

    public void setStart_duedate(String start_duedate) {
        this.start_duedate = start_duedate;
    }

    public String getDuedate_macro() {
        return this.duedate_macro;
    }

    public void setDuedate_macro(String duedate_macro) {
        this.duedate_macro = duedate_macro;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getSource_account() {
        return this.source_account;
    }

    public void setSource_account(String source_account) {
        this.source_account = source_account;
    }

    public String getAccount_type() {
        return this.account_type;
    }

    public void setAccount_type(String account_type) {
        this.account_type = account_type;
    }

    public String getSource_account_type() {
        return this.source_account_type;
    }

    public void setSource_account_type(String source_account_type) {
        this.source_account_type = source_account_type;
    }

    public String getAppaid() {
        return this.appaid;
    }

    public void setAppaid(String appaid) {
        this.appaid = appaid;
    }

    public String getAging_method() {
        return this.aging_method;
    }

    public void setAging_method(String aging_method) {
        this.aging_method = aging_method;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getSort_by() {
        return this.sort_by;
    }

    public void setSort_by(String sort_by) {
        this.sort_by = sort_by;
    }

    public String getSort_order() {
        return this.sort_order;
    }

    public void setSort_order(String sort_order) {
        this.sort_order = sort_order;
    }

    public String getGroup_by() {
        return this.group_by;
    }

    public void setGroup_by(String group_by) {
        this.group_by = group_by;
    }

    public String getCreatedate_macro() {
        return this.createdate_macro;
    }

    public void setCreatedate_macro(String createdate_macro) {
        this.createdate_macro = createdate_macro;
    }

    public String getEnd_createdate() {
        return this.end_createdate;
    }

    public void setEnd_createdate(String end_createdate) {
        this.end_createdate = end_createdate;
    }

    public String getStart_createdate() {
        return this.start_createdate;
    }

    public void setStart_createdate(String start_createdate) {
        this.start_createdate = start_createdate;
    }

    public String getModdate_macro() {
        return this.moddate_macro;
    }

    public void setModdate_macro(String moddate_macro) {
        this.moddate_macro = moddate_macro;
    }

    public String getEnd_moddate() {
        return this.end_moddate;
    }

    public void setEnd_moddate(String end_moddate) {
        this.end_moddate = end_moddate;
    }

    public String getStart_moddate() {
        return this.start_moddate;
    }

    public void setStart_moddate(String start_moddate) {
        this.start_moddate = start_moddate;
    }

    public String getPayment_method() {
        return this.payment_method;
    }

    public void setPayment_method(String payment_method) {
        this.payment_method = payment_method;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTransaction_type() {
        return this.transaction_type;
    }

    public void setTransaction_type(String transaction_type) {
        this.transaction_type = transaction_type;
    }

    public String getCleared() {
        return this.cleared;
    }

    public void setCleared(String cleared) {
        this.cleared = cleared;
    }

    public String getArpaid() {
        return this.arpaid;
    }

    public void setArpaid(String arpaid) {
        this.arpaid = arpaid;
    }

    public String getPrinted() {
        return this.printed;
    }

    public void setPrinted(String printed) {
        this.printed = printed;
    }

    public String getBoth_amount() {
        return this.both_amount;
    }

    public void setBoth_amount(String both_amount) {
        this.both_amount = both_amount;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getDoc_num() {
        return this.doc_num;
    }

    public void setDoc_num(String doc_num) {
        this.doc_num = doc_num;
    }

    public String getJournal_code() {
        return this.journal_code;
    }

    public void setJournal_code(String journal_code) {
        this.journal_code = journal_code;
    }

    public String getEmployee() {
        return this.employee;
    }

    public void setEmployee(String employee) {
        this.employee = employee;
    }

    public String getAgency_id() {
        return this.agency_id;
    }

    public void setAgency_id(String agency_id) {
        this.agency_id = agency_id;
    }

    public String getCustom1() {
        return this.custom1;
    }

    public void setCustom1(String custom1) {
        this.custom1 = custom1;
    }

    public String getCustom2() {
        return this.custom2;
    }

    public void setCustom2(String custom2) {
        this.custom2 = custom2;
    }

    public String getCustom3() {
        return this.custom3;
    }

    public void setCustom3(String custom3) {
        this.custom3 = custom3;
    }

    public String getShipvia() {
        return this.shipvia;
    }

    public void setShipvia(String shipvia) {
        this.shipvia = shipvia;
    }

    public String getAccount_status() {
        return this.account_status;
    }

    public void setAccount_status(String account_status) {
        this.account_status = account_status;
    }

    public String getSubcol_pct_inc() {
        return this.subcol_pct_inc;
    }

    public void setSubcol_pct_inc(String subcol_pct_inc) {
        this.subcol_pct_inc = subcol_pct_inc;
    }

    public String getSubcol_pct_exp() {
        return this.subcol_pct_exp;
    }

    public void setSubcol_pct_exp(String subcol_pct_exp) {
        this.subcol_pct_exp = subcol_pct_exp;
    }
}

