/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.intuit.ipp.data.IntuitEntity;
import com.intuit.ipp.util.Config;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import org.slf4j.Logger;

public class IntuitResponseDeserializerHelper {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();

    protected void invokeFeature(String featureSwitch, Feature feature) {
        if (Config.getBooleanProperty(featureSwitch, true).booleanValue()) {
            feature.execute();
        }
    }

    protected void updateBigDecimalScale(IntuitEntity intuitType) {
        Feature feature = new Feature(){
            private IntuitEntity obj;

            @Override
            public <T extends IntuitEntity> void set(T object) {
                this.obj = object;
            }

            @Override
            public void execute() {
                new BigDecimalScaleUpdater().execute(this.obj);
            }
        };
        feature.set(intuitType);
        this.invokeFeature("feature.bigDecimalScaleShift", feature);
    }

    protected class BigDecimalScaleUpdater {
        private final String GET = "get";
        private final String SET = "set";
        private final int POSITION_AFTER_PERIOD = 2;

        protected BigDecimalScaleUpdater() {
        }

        public void execute(IntuitEntity entity) {
            for (Field field : entity.getClass().getDeclaredFields()) {
                if (!this.isDecimal(field) || !this.isGetter(field) || !this.isSetter(field)) continue;
                try {
                    this.scaleTo(entity, field, 2);
                }
                catch (Exception ex) {
                    this.handleException(ex, field.getDeclaringClass().getSimpleName() + "." + field.getName());
                }
            }
        }

        private boolean isSetter(Field field) {
            return this.checkMethod(field, "set");
        }

        private boolean isGetter(Field field) {
            return this.checkMethod(field, "get");
        }

        private boolean checkMethod(Field field, String prefix) {
            try {
                Method method = this.getMethod(field, prefix);
                return null != method;
            }
            catch (NoSuchMethodException ex) {
                this.writeDebug("No " + prefix + "ter for " + field.getName());
                return false;
            }
        }

        private void scaleTo(IntuitEntity entity, Field field, int newScale) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            BigDecimal value = (BigDecimal)this.getMethod(field, "get").invoke((Object)entity, new Object[0]);
            if (value != null && newScale != value.scale()) {
                this.getMethod(field, "set").invoke((Object)entity, value.setScale(newScale));
            }
        }

        private void handleException(Exception ex, String name) {
            if (ex instanceof NoSuchMethodException) {
                this.writeDebug("No getter for " + name + ".");
            }
            if (ex instanceof IllegalAccessException) {
                this.writeDebug("Access to " + name + " using setter and getter methods failed.");
            }
            if (ex instanceof InvocationTargetException) {
                this.writeDebug("Bad target invocation for setter/getter for " + name + " field.");
            }
            if (ex instanceof Exception) {
                this.writeDebug("Unexpected exception for  " + name + " using setter/getter method. Message: " + ex.getMessage());
            }
        }

        private boolean isDecimal(Field field) {
            return field.getType().equals(BigDecimal.class);
        }

        private Method getMethod(Field field, String prefix) throws NoSuchMethodException {
            Class<?> clazz = field.getDeclaringClass();
            String methodName = prefix + this.upperCaseFirstLetter(field.getName());
            return "set".equals(prefix) ? clazz.getMethod(methodName, BigDecimal.class) : clazz.getMethod(methodName, new Class[0]);
        }

        private String upperCaseFirstLetter(String input) {
            if (input.length() == 0) {
                return input;
            }
            return input.substring(0, 1).toUpperCase() + input.substring(1);
        }

        private void writeDebug(String message) {
            LOG.debug(message);
        }
    }

    protected static interface Feature {
        public void execute();

        public <T extends IntuitEntity> void set(T var1);
    }
}

