/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.intuit.ipp.data.Attachable;
import com.intuit.ipp.data.AttachableResponse;
import com.intuit.ipp.data.Fault;
import java.io.IOException;
import java.util.Iterator;

public class AttachableResponseDeserializer
extends JsonDeserializer<AttachableResponse> {
    private static final String FAULT = "Fault";
    private static final String ATTACHABLE = "Attachable";

    @Override
    public AttachableResponse deserialize(JsonParser jp, DeserializationContext desContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair(primary, secondary);
        mapper.setAnnotationIntrospector(pair);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode jn = (JsonNode)jp.readValueAsTree();
        AttachableResponse qr = new AttachableResponse();
        Iterator<String> ite = jn.fieldNames();
        while (ite.hasNext()) {
            String key = ite.next();
            if (key.equalsIgnoreCase(FAULT)) {
                qr.setFault(mapper.treeToValue(jn.get(FAULT), Fault.class));
                continue;
            }
            if (!key.equalsIgnoreCase(ATTACHABLE)) continue;
            qr.setAttachable(mapper.treeToValue(jn.get(ATTACHABLE), Attachable.class));
        }
        return qr;
    }
}

