/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.security;

import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.security.IAuthorizer;
import com.intuit.ipp.util.Config;
import com.intuit.ipp.util.StringUtils;
import java.net.HttpURLConnection;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import org.apache.http.client.methods.HttpRequestBase;

public class OAuthAuthorizer
implements IAuthorizer {
    private OAuthConsumer oAuthConsumer;

    @Override
    public void authorize(HttpRequestBase httpRequest) throws FMSException {
        try {
            this.oAuthConsumer.sign(httpRequest);
        }
        catch (OAuthMessageSignerException e) {
            throw new FMSException(e);
        }
        catch (OAuthExpectationFailedException e) {
            throw new FMSException(e);
        }
        catch (OAuthCommunicationException e) {
            throw new FMSException(e);
        }
    }

    @Override
    public void authorize(HttpURLConnection httpUrlConnection) throws FMSException {
        try {
            this.oAuthConsumer.sign(httpUrlConnection);
        }
        catch (OAuthMessageSignerException e) {
            throw new FMSException(e);
        }
        catch (OAuthExpectationFailedException e) {
            throw new FMSException(e);
        }
        catch (OAuthCommunicationException e) {
            throw new FMSException(e);
        }
    }

    private OAuthAuthorizer(String consumerKey, String consumerSecret) {
        String httpTransport = Config.getProperty("httpTransport");
        this.oAuthConsumer = StringUtils.hasText(httpTransport) && httpTransport.equals("HTTP_URL_CONNECTION") ? new DefaultOAuthConsumer(consumerKey, consumerSecret) : new CommonsHttpOAuthConsumer(consumerKey, consumerSecret);
    }

    public OAuthAuthorizer(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        this(OAuthAuthorizer.trim(consumerKey), OAuthAuthorizer.trim(consumerSecret));
        this.oAuthConsumer.setTokenWithSecret(OAuthAuthorizer.trim(accessToken), OAuthAuthorizer.trim(accessTokenSecret));
        this.oAuthConsumer.setSigningStrategy(new AuthorizationHeaderSigningStrategy());
    }

    private static String trim(String key) {
        if (key == null) {
            return null;
        }
        return key.trim();
    }
}

