/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.CallbackHandlerInterceptor;
import com.intuit.ipp.interceptors.CompressionInterceptor;
import com.intuit.ipp.interceptors.DecompressionInterceptor;
import com.intuit.ipp.interceptors.DeserializeInterceptor;
import com.intuit.ipp.interceptors.HTTPClientConnectionInterceptor;
import com.intuit.ipp.interceptors.HTTPURLConnectionInterceptor;
import com.intuit.ipp.interceptors.HandleResponseInterceptor;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.PrepareRequestInterceptor;
import com.intuit.ipp.interceptors.SerializeInterceptor;
import com.intuit.ipp.services.CallbackMessage;
import com.intuit.ipp.util.Config;
import com.intuit.ipp.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;

public class IntuitInterceptorProvider
implements Callable<Void> {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private List<Interceptor> requestInterceptors = new ArrayList<Interceptor>();
    private List<Interceptor> responseInterceptors = new ArrayList<Interceptor>();
    private IntuitMessage intuitMessage = null;
    private Configuration configuration = null;

    public IntuitInterceptorProvider() {
        this.requestInterceptors.add(new PrepareRequestInterceptor());
        this.requestInterceptors.add(new SerializeInterceptor());
        this.requestInterceptors.add(new CompressionInterceptor());
        this.requestInterceptors.add(this.getConnectionInterceptor());
        this.responseInterceptors.add(new DecompressionInterceptor());
        this.responseInterceptors.add(new DeserializeInterceptor());
        this.responseInterceptors.add(new HandleResponseInterceptor());
    }

    public void executeInterceptors(IntuitMessage intuitMessage) throws FMSException {
        this.executeRequestInterceptors(intuitMessage);
        this.executeResponseInterceptors(intuitMessage);
    }

    protected void executeRequestInterceptors(IntuitMessage intuitMessage) throws FMSException {
        for (Interceptor interceptor : this.requestInterceptors) {
            interceptor.execute(intuitMessage);
        }
    }

    protected void executeResponseInterceptors(IntuitMessage intuitMessage) throws FMSException {
        for (Interceptor interceptor : this.responseInterceptors) {
            interceptor.execute(intuitMessage);
        }
    }

    public void executeAsyncInterceptors(IntuitMessage intuitMessage) {
        this.intuitMessage = intuitMessage;
        this.configuration = Config.cloneConfigurationOverrides();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(this);
    }

    private Interceptor getConnectionInterceptor() {
        String httpTransport = Config.getProperty("httpTransport");
        if (StringUtils.hasText(httpTransport) && httpTransport.equals("HTTP_URL_CONNECTION")) {
            return new HTTPURLConnectionInterceptor();
        }
        return new HTTPClientConnectionInterceptor();
    }

    @Override
    public Void call() throws FMSException {
        CallbackMessage callbackMessage = new CallbackMessage();
        try {
            Config.addConfigurationOverrides(this.configuration);
            this.executeInterceptors(this.intuitMessage);
        }
        catch (FMSException e) {
            callbackMessage.setFMSException(e);
            LOG.error("Exception in interceptor flow", e);
        }
        this.intuitMessage.getResponseElements().setCallbackMessage(callbackMessage);
        new CallbackHandlerInterceptor().execute(this.intuitMessage);
        return null;
    }

    protected List<Interceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    protected void setRequestInterceptors(List<Interceptor> requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }
}

