/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.core.Response;
import com.intuit.ipp.data.EntitlementsResponse;
import com.intuit.ipp.data.IntuitResponse;
import com.intuit.ipp.data.TaxService;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.ResponseElements;
import com.intuit.ipp.net.ContentTypes;
import com.intuit.ipp.serialization.IEntitySerializer;
import com.intuit.ipp.serialization.SerializerFactory;
import com.intuit.ipp.util.StringUtils;
import org.slf4j.Logger;

public class DeserializeInterceptor
implements Interceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
        LOG.debug("Enter DeserializeInterceptor...");
        Response response = null;
        ResponseElements responseElements = intuitMessage.getResponseElements();
        String contentType = responseElements.getContentTypeHeader();
        if (contentType != null) {
            String[] contentTypes;
            for (String contentTypePart : contentTypes = contentType.split(";")) {
                if (!contentTypePart.matches("(.*)/(.*)")) continue;
                String serializeFormat = contentTypePart.substring(contentTypePart.lastIndexOf("/") + 1, contentTypePart.length());
                LOG.info("HttpResponse content-type (deserialization format) : " + serializeFormat);
                LOG.debug("HttpResponse content-type (deserialization format) : " + serializeFormat);
                if (StringUtils.hasText(serializeFormat) && (serializeFormat.equalsIgnoreCase(ContentTypes.XML.name()) || serializeFormat.equalsIgnoreCase(ContentTypes.JSON.name()))) {
                    IEntitySerializer serializer = SerializerFactory.getSerializer(serializeFormat);
                    if (intuitMessage.getRequestElements().getObjectToSerialize() instanceof TaxService && serializeFormat.equalsIgnoreCase(ContentTypes.JSON.name())) {
                        response = serializer.deserialize(responseElements.getDecompressedData(), TaxService.class);
                        continue;
                    }
                    if (intuitMessage.isEntitlementService()) {
                        if (StringUtils.hasText(responseElements.getDecompressedData())) {
                            response = serializer.deserializeEntitlements(responseElements.getDecompressedData(), EntitlementsResponse.class);
                            continue;
                        }
                        response = responseElements.getResponse();
                        continue;
                    }
                    response = serializer.deserialize(responseElements.getDecompressedData(), IntuitResponse.class);
                    continue;
                }
                if (serializeFormat.equalsIgnoreCase(ContentTypes.PDF.name()) || serializeFormat.equalsIgnoreCase("plain") || serializeFormat.equalsIgnoreCase("octet-stream")) {
                    LOG.info("PDF or plain content has been received");
                    continue;
                }
                LOG.info("Invalid Content Type" + serializeFormat);
                LOG.debug("Decompressed Data" + responseElements.getDecompressedData());
                LOG.error("Decompressed Data" + responseElements.getDecompressedData());
                throw new FMSException(responseElements.getDecompressedData());
            }
        }
        responseElements.setResponse(response);
        LOG.debug("Exit DeserializeInterceptor.");
    }
}

