/*
 * Decompiled with CFR 0.152.
 */
package com.instapp.nat.weex.plugin.media.Image;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.alibaba.weex.plugin.annotation.WeexModule;
import com.instapp.nat.media.image.ImageModule;
import com.instapp.nat.media.image.ModuleResultListener;
import com.instapp.nat.media.image.Util;
import com.instapp.nat.permission.PermissionChecker;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import java.util.HashMap;
import java.util.Locale;

@WeexModule(name="nat/media/image")
public class Image
extends WXModule {
    JSCallback mPickCallback;
    HashMap<String, Object> mPickParam;
    JSCallback mPreviewCallback;
    String[] mFiles;
    HashMap<String, Object> mPreviewParam;
    public static final int PICK_REQUEST_CODE = 101;
    public static final int PREVIEW_REQUEST_CODE = 102;
    String lang = Locale.getDefault().getLanguage();
    Boolean isChinese = this.lang.startsWith("zh");

    @JSMethod
    public void pick(HashMap<String, Object> param, final JSCallback jsCallback) {
        this.mPickCallback = jsCallback;
        this.mPickParam = param;
        boolean b = PermissionChecker.lacksPermissions((Context)this.mWXSDKInstance.getContext(), (String[])new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        if (b) {
            HashMap<String, String> dialog = new HashMap<String, String>();
            if (this.isChinese.booleanValue()) {
                dialog.put("title", "\u6743\u9650\u7533\u8bf7");
                dialog.put("message", "\u8bf7\u5141\u8bb8\u5e94\u7528\u8bbf\u95ee\u76f8\u518c");
            } else {
                dialog.put("title", "Permission Request");
                dialog.put("message", "Please allow the app to access photos");
            }
            PermissionChecker.requestPermissions((Activity)((Activity)this.mWXSDKInstance.getContext()), dialog, (com.instapp.nat.permission.ModuleResultListener)new com.instapp.nat.permission.ModuleResultListener(){

                public void onResult(Object o) {
                    if (o != null && o.toString().equals("true")) {
                        jsCallback.invoke((Object)Util.getError((String)"CAMERA_PERMISSION_DENIED", (int)120020));
                    }
                }
            }, (int)101, (String[])new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        } else {
            ImageModule.getInstance((Context)this.mWXSDKInstance.getContext()).pick((Activity)this.mWXSDKInstance.getContext(), param);
        }
    }

    @JSMethod
    public void preview(String[] files, HashMap<String, Object> param, final JSCallback jsCallback) {
        this.mPreviewCallback = jsCallback;
        this.mPreviewParam = param;
        this.mFiles = files;
        boolean b = PermissionChecker.lacksPermissions((Context)this.mWXSDKInstance.getContext(), (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
        if (b) {
            HashMap<String, String> dialog = new HashMap<String, String>();
            if (this.isChinese.booleanValue()) {
                dialog.put("title", "\u6743\u9650\u7533\u8bf7");
                dialog.put("message", "\u8bf7\u5141\u8bb8\u5e94\u7528\u8bbf\u95ee\u76f8\u518c\u53ca\u6587\u4ef6");
            } else {
                dialog.put("title", "Permission Request");
                dialog.put("message", "Please allow the app to access photos and files on your device");
            }
            PermissionChecker.requestPermissions((Activity)((Activity)this.mWXSDKInstance.getContext()), dialog, (com.instapp.nat.permission.ModuleResultListener)new com.instapp.nat.permission.ModuleResultListener(){

                public void onResult(Object o) {
                    if (o != null && o.toString().equals("true")) {
                        jsCallback.invoke((Object)Util.getError((String)"MEDIA_INTERNAL_ERROR", (int)110000));
                    }
                }
            }, (int)102, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
        } else {
            ImageModule.getInstance((Context)this.mWXSDKInstance.getContext()).preview(files, param, new ModuleResultListener(){

                public void onResult(Object o) {
                    jsCallback.invoke(o);
                }
            });
        }
    }

    @JSMethod
    public void info(String path, final JSCallback jsCallback) {
        ImageModule.getInstance((Context)this.mWXSDKInstance.getContext()).info(path, new ModuleResultListener(){

            public void onResult(Object o) {
                jsCallback.invoke(o);
            }
        });
    }

    @JSMethod
    public void exif(String path, final JSCallback jsCallback) {
        ImageModule.getInstance((Context)this.mWXSDKInstance.getContext()).exif(path, new ModuleResultListener(){

            public void onResult(Object o) {
                jsCallback.invoke(o);
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Object o = ImageModule.getInstance((Context)this.mWXSDKInstance.getContext()).onPickActivityResult(requestCode, resultCode, data);
        if (this.mPickCallback != null) {
            this.mPickCallback.invoke(o);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 101) {
            if (PermissionChecker.hasAllPermissionsGranted((int[])grantResults)) {
                ImageModule.getInstance((Context)this.mWXSDKInstance.getContext()).pick((Activity)this.mWXSDKInstance.getContext(), this.mPickParam);
            } else {
                this.mPickCallback.invoke((Object)Util.getError((String)"CAMERA_PERMISSION_DENIED", (int)120020));
            }
        }
        if (requestCode == 102) {
            if (PermissionChecker.hasAllPermissionsGranted((int[])grantResults)) {
                ImageModule.getInstance((Context)this.mWXSDKInstance.getContext()).preview(this.mFiles, this.mPreviewParam, new ModuleResultListener(){

                    public void onResult(Object o) {
                        Image.this.mPreviewCallback.invoke(o);
                    }
                });
            } else {
                this.mPreviewCallback.invoke((Object)Util.getError((String)"MEDIA_INTERNAL_ERROR", (int)110000));
            }
        }
    }
}

