/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.models;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ListUtils;
import com.instabug.survey.common.a.a;
import com.instabug.survey.common.a.e;
import com.instabug.survey.common.a.f;
import com.instabug.survey.common.a.g;
import com.instabug.survey.common.a.i;
import com.instabug.survey.models.b;
import com.instabug.survey.models.c;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Survey
implements Cacheable,
e,
Serializable {
    private static final String KEY_PUBLISHED = "published";
    private static final String KEY_PAUSED = "paused";
    private static final String KEY_ID = "id";
    private static final String KEY_TITLE = "title";
    private static final String KEY_TOKEN = "token";
    private static final String HAS_RESPOND = "has_respond";
    private static final String KEY_QUESTIONS = "questions";
    private static final String KEY_TARGET = "target";
    private static final String KEY_TARGET_AUDIENCE = "primitive_types";
    private static final String KEY_CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String KEY_USER_EVENTS = "user_events";
    private static final String KEY_CONDITIONS_OPERATOR = "operator";
    private static final String KEY_ANSWERED = "answered";
    private static final String KEY_DISMISSED_AT = "dismissed_at";
    private static final String KEY_IS_CANCELLED = "is_cancelled";
    private static final String KEY_SURVEY_EVENTS = "events";
    private static final String KEY_SURVEY_STATE = "survey_state";
    private static final String KEY_SHOULD_SHOW_AGAIN = "should_show_again";
    private static final String KEY_SESSION_COUNTER = "session_counter";
    private static final String KEY_WELCOME_SCREEN = "welcome_screen";
    private static final String KEY_TYPE = "type";
    private static final String KEY_THANKS_LIST = "thanks_list";
    private static final String KEY_SHOW_AT = "show_at";
    private long id;
    private String title;
    private int type;
    private String token;
    private ArrayList<b> questions;
    private i userInteraction;
    private boolean paused = false;
    private ArrayList<c> thankYouItems;
    private com.instabug.survey.common.a.b localization = new com.instabug.survey.common.a.b();

    public Survey() {
        this.userInteraction = new i(0);
    }

    public static List<Survey> getPausedSurveysFromJson(JSONObject response) throws JSONException {
        JSONArray jSONArray = response.getJSONArray(KEY_PAUSED);
        ArrayList<Survey> arrayList = new ArrayList<Survey>(jSONArray.length());
        for (int j = 0; j < jSONArray.length(); ++j) {
            Survey survey = new Survey();
            survey.setId(jSONArray.getLong(j));
            survey.setPaused(true);
            arrayList.add(survey);
        }
        return arrayList;
    }

    public static List<Survey> fromJson(JSONObject surveysJsonObject) throws JSONException {
        JSONArray jSONArray = surveysJsonObject.getJSONArray(KEY_PUBLISHED);
        ArrayList<Survey> arrayList = new ArrayList<Survey>();
        for (int j = 0; j < jSONArray.length(); ++j) {
            JSONObject jSONObject = jSONArray.getJSONObject(j);
            Survey survey = new Survey();
            survey.fromJson(jSONObject.toString());
            arrayList.add(survey);
        }
        return arrayList;
    }

    public g getTarget() {
        return this.userInteraction.c();
    }

    public void setTarget(g target) {
        this.userInteraction.a(target);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public long getSurveyId() {
        return this.id;
    }

    @Override
    public i getUserInteraction() {
        return this.userInteraction;
    }

    public void setUserInteraction(i userInteraction) {
        this.userInteraction = userInteraction;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubmitted() {
        a a2;
        this.setCancelled(false);
        this.setAnswered(true);
        if (this.isNPSSurvey() && this.isAnswered() && this.hasNPSSubmitted() && this.hasPositiveNpsAnswer()) {
            a2 = new a(a.a.RATE, System.currentTimeMillis() / 1000L, this.getEventIndex());
        } else {
            a2 = new a(a.a.SUBMIT, System.currentTimeMillis() / 1000L, this.getEventIndex());
            if (this.isOptInSurvey()) {
                this.userInteraction.b(0);
            }
        }
        this.setSurveyState(f.READY_TO_SEND);
        g g2 = this.userInteraction.c();
        if (g2.d().size() > 0 && g2.d().get(g2.d().size() - 1).a() == a.a.SUBMIT && a2.a() == a.a.SUBMIT) {
            return;
        }
        g2.d().add(a2);
    }

    public boolean isNPSSurvey() {
        return this.getType() == 1;
    }

    public boolean isStoreRatingSurvey() {
        return this.getType() == 2;
    }

    public ArrayList<b> getQuestions() {
        return this.questions;
    }

    public void setQuestions(ArrayList<b> question) {
        this.questions = question;
    }

    public ArrayList<com.instabug.survey.common.a.c> getTargetAudiences() {
        return this.userInteraction.c().a();
    }

    public void setTargetAudiences(ArrayList<com.instabug.survey.common.a.c> targetAudiences) {
        this.userInteraction.c().a(targetAudiences);
    }

    public ArrayList<com.instabug.survey.common.a.c> getCustomAttributes() {
        return this.userInteraction.c().b();
    }

    public void setCustomAttributes(ArrayList<com.instabug.survey.common.a.c> customAttributes) {
        this.userInteraction.c().b(customAttributes);
    }

    public ArrayList<com.instabug.survey.common.a.c> getUserEvents() {
        return this.userInteraction.c().c();
    }

    public void setUserEvents(ArrayList<com.instabug.survey.common.a.c> userEvents) {
        this.userInteraction.c().c(userEvents);
    }

    public ArrayList<a> getSurveyEvents() {
        return this.userInteraction.c().d();
    }

    public void setSurveyEvents(ArrayList<a> actionEvents) {
        this.userInteraction.c().d(actionEvents);
    }

    public String getConditionsOperator() {
        return this.userInteraction.c().e();
    }

    public void setConditionsOperator(String conditionOperator) {
        this.userInteraction.c().b(conditionOperator);
    }

    public boolean hasPositiveNpsAnswer() {
        return this.isNPSSurvey() && (this.isPromoter() || this.isPassive());
    }

    private boolean hasNPSSubmitted() {
        if (this.userInteraction.c().d() != null) {
            for (a a2 : this.userInteraction.c().d()) {
                if (a2.a() != a.a.SUBMIT) continue;
                return true;
            }
        }
        return false;
    }

    public int getEventIndex() {
        return this.userInteraction.e();
    }

    public void setEventIndex(int eventIndex) {
        this.userInteraction.a(eventIndex);
    }

    public boolean isOptInSurvey() {
        return this.getToken() != null && !String.valueOf(this.getToken()).equals("null");
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setDismissed() {
        this.setSurveyState(f.READY_TO_SEND);
        if (this.isNPSSurvey() && this.hasPositiveNpsAnswer() && this.hasNPSSubmitted()) {
            return;
        }
        this.setShouldShowAgain(this.isOptInSurvey() || this.userInteraction.i() == 0L);
        this.userInteraction.c(System.currentTimeMillis() / 1000L);
        this.setCancelled(true);
        if (this.userInteraction.c().d().size() > 0 && this.userInteraction.c().d().get(this.userInteraction.c().d().size() - 1).a() == a.a.DISMISS) {
            return;
        }
        a a2 = new a(a.a.DISMISS, this.userInteraction.i(), this.getEventIndex());
        this.userInteraction.c().d().add(a2);
    }

    public void addShowEvent() {
        this.userInteraction.b(System.currentTimeMillis() / 1000L);
        this.userInteraction.p();
        a a2 = new a(a.a.SHOW, this.userInteraction.h(), this.userInteraction.n());
        this.userInteraction.c().d().add(a2);
    }

    public void addRateEvent() {
        a a2 = new a(a.a.RATE, System.currentTimeMillis() / 1000L, this.getAttemptCount());
        this.userInteraction.c().d().add(a2);
    }

    public long getShownAt() {
        return this.userInteraction.h();
    }

    public void setShowAt(long shownAt) {
        this.userInteraction.b(shownAt);
    }

    public int getAttemptCount() {
        return this.userInteraction.f();
    }

    public void setAttemptCount(int attemptsCount) {
        this.userInteraction.b(attemptsCount);
    }

    public void setSessionCount(int sessionCount) {
        this.userInteraction.c(sessionCount);
    }

    private boolean isPromoter() {
        return this.getNPSAnswerValue() > 8;
    }

    private boolean isPassive() {
        return this.getNPSAnswerValue() > 6 && this.getNPSAnswerValue() <= 8;
    }

    private boolean isDetractor() {
        return this.getNPSAnswerValue() <= 6;
    }

    private int getNPSAnswerValue() {
        try {
            return Integer.parseInt(((b)ListUtils.safeGet(this.questions, (int)0)).e());
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((Object)this, (String)("NPS score parsing failed du to: " + exception.getMessage()));
            return 0;
        }
    }

    @Nullable
    public String getThankYouTitle() {
        return this.isNPSSurvey() ? this.getNPSThankYouTitle() : this.getCustomThankYouTitle();
    }

    private String getNPSThankYouTitle() {
        ArrayList<c> arrayList = this.getThankYouItems();
        if (arrayList.size() > 0) {
            c c2 = (c)ListUtils.safeGet(arrayList, (int)0);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)1);
            c c4 = (c)ListUtils.safeGet(arrayList, (int)2);
            if (this.isPromoter() && c2 != null) {
                return c2.a();
            }
            if (this.isPassive() && c3 != null) {
                return c3.a();
            }
            if (this.isDetractor() && c4 != null) {
                return c4.a();
            }
        }
        return null;
    }

    private String getCustomThankYouTitle() {
        c c2;
        ArrayList<c> arrayList = this.getThankYouItems();
        if (arrayList.size() > 0 && (c2 = (c)ListUtils.safeGet(arrayList, (int)0)) != null) {
            return c2.a();
        }
        return null;
    }

    @Nullable
    public String getThankYouMessage() {
        return this.isNPSSurvey() ? this.getNPSThankYouMessage() : this.getCustomThankYouMessage();
    }

    private String getNPSThankYouMessage() {
        ArrayList<c> arrayList = this.getThankYouItems();
        if (arrayList.size() > 0) {
            c c2 = (c)ListUtils.safeGet(arrayList, (int)0);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)1);
            c c4 = (c)ListUtils.safeGet(arrayList, (int)2);
            if (this.isPromoter() && c2 != null) {
                return c2.b();
            }
            if (this.isPassive() && c3 != null) {
                return c3.b();
            }
            if (this.isDetractor() && c4 != null) {
                return c4.b();
            }
        }
        return null;
    }

    private String getCustomThankYouMessage() {
        c c2;
        ArrayList<c> arrayList = this.getThankYouItems();
        if (arrayList.size() > 0 && (c2 = (c)ListUtils.safeGet(arrayList, (int)0)) != null) {
            return c2.b();
        }
        return null;
    }

    public boolean isAppStoreRatingEnabled() {
        ArrayList<c> arrayList = this.getThankYouItems();
        if (arrayList.size() > 0) {
            c c2 = (c)ListUtils.safeGet(arrayList, (int)0);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)1);
            if (this.isPromoter() && c2 != null) {
                return c2.d();
            }
            if (this.isPassive() && c3 != null) {
                return c3.d();
            }
        }
        return false;
    }

    @Nullable
    public String getRatingCTATitle() {
        ArrayList<c> arrayList;
        if (this.isAppStoreRatingEnabled() && (arrayList = this.getThankYouItems()).size() > 0) {
            c c2 = (c)ListUtils.safeGet(arrayList, (int)0);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)1);
            if (this.isPromoter() && c2 != null) {
                return c2.c();
            }
            if (this.isPassive() && c3 != null) {
                return c3.c();
            }
        }
        return null;
    }

    public void incrementSessionCount() {
        this.userInteraction.o();
    }

    public boolean isCancelled() {
        return this.userInteraction.g();
    }

    public void setCancelled(boolean cancelled) {
        this.userInteraction.a(cancelled);
    }

    public void resetSessionsCounter() {
        this.userInteraction.c(0);
    }

    public void resetUserInteractions() {
        g g2 = this.userInteraction.c();
        g2.d(new ArrayList<a>());
        this.userInteraction = new i(0);
        this.userInteraction.a(g2);
    }

    public void resetUserAnswers() {
        for (b b2 : this.questions) {
            b2.f();
        }
    }

    public long getRespondedAt() {
        if (this.isLastEventDismiss()) {
            return 0L;
        }
        if (this.userInteraction.c().d() != null && this.userInteraction.c().d().size() > 0) {
            for (a a2 : this.userInteraction.c().d()) {
                if (a2.a() != a.a.SUBMIT) continue;
                return a2.b();
            }
        }
        if (this.getQuestions() != null && this.getQuestions().size() > 0) {
            for (int j = this.getQuestions().size() - 1; j >= 0; --j) {
                if (this.getQuestions().get(j).g() <= 0L) continue;
                return this.getQuestions().get(j).g();
            }
        }
        return 0L;
    }

    public boolean isLastEventDismiss() {
        return this.userInteraction.c().d() != null && this.userInteraction.c().d().size() > 0 && this.userInteraction.c().d().get(this.userInteraction.c().d().size() - 1).a() == a.a.DISMISS;
    }

    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_ID, this.id).put(KEY_TYPE, this.type).put(KEY_TITLE, (Object)this.title).put(KEY_TOKEN, (Object)this.token).put(KEY_QUESTIONS, (Object)b.a(this.questions)).put(KEY_TARGET, (Object)g.a(this.userInteraction.c())).put(KEY_SURVEY_EVENTS, (Object)a.a(this.userInteraction.c().d())).put(KEY_ANSWERED, this.userInteraction.j()).put(KEY_SHOW_AT, this.userInteraction.h()).put(KEY_DISMISSED_AT, this.getDismissedAt()).put(KEY_IS_CANCELLED, this.userInteraction.g()).put(KEY_SURVEY_STATE, (Object)this.getSurveyState().toString()).put(KEY_SHOULD_SHOW_AGAIN, this.shouldShowAgain()).put(KEY_THANKS_LIST, (Object)c.a(this.thankYouItems)).put(KEY_SESSION_COUNTER, this.getSessionCounter());
        this.localization.a(jSONObject);
        return jSONObject.toString();
    }

    public boolean shouldShowAgain() {
        return this.userInteraction.l();
    }

    public long getDismissedAt() {
        return this.userInteraction.i();
    }

    public void setDismissedAt(long dismissedAt) {
        this.userInteraction.c(dismissedAt);
    }

    public f getSurveyState() {
        return this.userInteraction.m();
    }

    public void setSurveyState(f surveyState) {
        this.userInteraction.a(surveyState);
    }

    public int getSessionCounter() {
        return this.userInteraction.k();
    }

    private void setSessionCounter(int sessionCounter) {
        this.userInteraction.c(sessionCounter);
    }

    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject jSONObject = new JSONObject(modelAsJson);
        if (jSONObject.has(KEY_ID)) {
            this.setId(jSONObject.getLong(KEY_ID));
        }
        if (jSONObject.has(KEY_TYPE)) {
            int n = jSONObject.getInt(KEY_TYPE);
            this.setType(n);
        }
        if (jSONObject.has(KEY_TITLE)) {
            this.setTitle(jSONObject.getString(KEY_TITLE));
        }
        if (jSONObject.has(KEY_TOKEN) && jSONObject.get(KEY_TOKEN) != JSONObject.NULL) {
            this.setToken(jSONObject.getString(KEY_TOKEN));
        }
        if (jSONObject.has(KEY_SURVEY_EVENTS)) {
            this.userInteraction.c().d(a.a(jSONObject.getJSONArray(KEY_SURVEY_EVENTS)));
        }
        if (jSONObject.has(KEY_QUESTIONS)) {
            this.setQuestions(b.a(jSONObject.getJSONArray(KEY_QUESTIONS)));
        }
        if (jSONObject.has(KEY_TARGET)) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(KEY_TARGET);
            this.userInteraction.c().fromJson(jSONObject2.toString().replace("\\", ""));
        }
        if (jSONObject.has(KEY_ANSWERED)) {
            this.setAnswered(jSONObject.getBoolean(KEY_ANSWERED));
        }
        if (jSONObject.has(KEY_IS_CANCELLED)) {
            this.setCancelled(jSONObject.getBoolean(KEY_IS_CANCELLED));
        }
        if (jSONObject.has(KEY_SURVEY_STATE)) {
            this.setSurveyState(f.valueOf(jSONObject.getString(KEY_SURVEY_STATE)));
        }
        if (jSONObject.has(KEY_SHOULD_SHOW_AGAIN)) {
            this.setShouldShowAgain(jSONObject.getBoolean(KEY_SHOULD_SHOW_AGAIN));
        }
        if (jSONObject.has(KEY_SESSION_COUNTER)) {
            this.setSessionCounter(jSONObject.getInt(KEY_SESSION_COUNTER));
        }
        if (jSONObject.has(KEY_DISMISSED_AT)) {
            this.setDismissedAt(jSONObject.getInt(KEY_DISMISSED_AT));
        }
        if (jSONObject.has(KEY_SHOW_AT)) {
            this.setShowAt(jSONObject.getInt(KEY_SHOW_AT));
        }
        if (jSONObject.has(KEY_THANKS_LIST)) {
            JSONArray jSONArray = jSONObject.getJSONArray(KEY_THANKS_LIST);
            this.setThankYouItems(c.a(jSONArray));
        }
        this.localization.b(jSONObject);
    }

    public long getId() {
        return this.id;
    }

    public Survey setId(long id2) {
        this.id = id2;
        return this;
    }

    public void setThankYouItems(ArrayList<c> thankYouItems) {
        this.thankYouItems = thankYouItems;
    }

    public ArrayList<c> getThankYouItems() {
        return this.thankYouItems;
    }

    public boolean isAnswered() {
        return this.userInteraction.j();
    }

    public void setAnswered(boolean answered) {
        this.userInteraction.b(answered);
    }

    public void setShouldShowAgain(boolean shouldShowAgain) {
        this.userInteraction.c(shouldShowAgain);
    }

    public com.instabug.survey.common.a.b getLocalization() {
        return this.localization;
    }

    public void setLocalization(com.instabug.survey.common.a.b localization) {
        this.localization = localization;
    }

    public void clearAnswers() {
        for (b b2 : this.questions) {
            b2.b((String)null);
        }
    }

    public boolean isLastEventSubmit() {
        return this.userInteraction.c().d() != null && this.userInteraction.c().d().size() > 0 && this.userInteraction.c().d().get(this.userInteraction.c().d().size() - 1).a() == a.a.SUBMIT;
    }

    public int hashCode() {
        return String.valueOf(this.getId()).hashCode();
    }

    public boolean equals(Object survey) {
        if (survey instanceof Survey) {
            Survey survey2 = (Survey)survey;
            return survey2.getId() == this.getId();
        }
        return false;
    }

    @NonNull
    public String toString() {
        try {
            return this.toJson();
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e((Object)"Survey", (String)jSONException.getMessage(), (Throwable)jSONException);
            return super.toString();
        }
    }
}

