/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.cache;

import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.b.c;
import java.util.ArrayList;
import java.util.List;

public class SurveysCacheManager {
    public static final String SURVEYS_DISK_CACHE_FILE_NAME = "/surveys.cache";
    public static final String SURVEYS_DISK_CACHE_KEY = "surveys_disk_cache";
    public static final String SURVEYS_MEMORY_CACHE_KEY = "surveys_memory_cache";

    public static InMemoryCache<Long, c> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(SURVEYS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(SurveysCacheManager.class, (String)("In-memory Surveys cache not found, loading it from disk " + CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY)));
            CacheManager.getInstance().migrateCache(SURVEYS_DISK_CACHE_KEY, SURVEYS_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<Long, c>(){

                public Long a(c c2) {
                    return c2.a();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((c)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(SurveysCacheManager.class, (String)("In-memory Surveys cache restored from disk, " + cache.size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(SurveysCacheManager.class, (String)"In-memory Surveys cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        Cache cache = CacheManager.getInstance().getCache(SURVEYS_DISK_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
        if (cache != null && cache2 != null) {
            CacheManager.getInstance().migrateCache(cache2, cache, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, c>(){

                public String a(c c2) {
                    return String.valueOf(c2.a());
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((c)object);
                }
            });
        }
    }

    public static void addSurvey(c c2) {
        InMemoryCache<Long, c> inMemoryCache = SurveysCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put((Object)c2.a(), (Object)c2);
        }
    }

    public static void addSurveys(List<c> list) {
        for (c c2 : list) {
            SurveysCacheManager.addSurvey(c2);
        }
    }

    public static List<c> getSurveys() {
        InMemoryCache<Long, c> inMemoryCache = SurveysCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.getValues();
        }
        return new ArrayList<c>();
    }

    public static List<c> getNotAnsweredSurveys() {
        ArrayList<c> arrayList = new ArrayList<c>();
        InMemoryCache<Long, c> inMemoryCache = SurveysCacheManager.getCache();
        if (inMemoryCache != null) {
            List list = inMemoryCache.getValues();
            for (c c2 : list) {
                if (c2.g()) continue;
                arrayList.add(c2);
                InstabugSDKLogger.d(SurveysCacheManager.class, (String)("survey id: " + c2.a()));
            }
        }
        InstabugSDKLogger.d(SurveysCacheManager.class, (String)("NotAnsweredSurveys size: " + arrayList.size()));
        return arrayList;
    }

    public static List<c> getAnsweredAndNotSubmittedSurveys() {
        ArrayList<c> arrayList = new ArrayList<c>();
        InMemoryCache<Long, c> inMemoryCache = SurveysCacheManager.getCache();
        if (inMemoryCache != null) {
            List list = inMemoryCache.getValues();
            InstabugSDKLogger.d(SurveysCacheManager.class, (String)("size: " + list.size()));
            for (c c2 : list) {
                if (!c2.g() || c2.h()) continue;
                arrayList.add(c2);
            }
        }
        return arrayList;
    }
}

