package com.instabug.survey.utils;

import androidx.annotation.NonNull;

import com.instabug.library.util.filters.Filter;
import com.instabug.library.util.filters.Filters;
import com.instabug.survey.common.models.Condition;

import java.util.ArrayList;

/**
 * A set of Surveys-related {@link Filter}s that can be used to provide control over what is passed
 * through {@link Filters} chain
 */
public final class SurveysFilterFunctions {

    /**
     * Processes the passed collection of {@link Condition}s to filter out all conditions that are
     * not defined in {@link TargetingCondition}.
     *
     * @return a {@link Filter} that returns a filtered collection of conditions
     */
    @NonNull
    public static Filter<ArrayList<Condition>> knownInstabugConditions() {
        return new Filter<ArrayList<Condition>>() {
            @Override
            public ArrayList<Condition> apply(ArrayList<Condition> conditions) {
                ArrayList<Condition> instabugConditions = new ArrayList<>();
                for (Condition condition : conditions) {
                    if (isKnownCondition(condition)) instabugConditions.add(condition);
                }
                return instabugConditions;
            }

            private boolean isKnownCondition(Condition condition) {
                return SurveysUtils.isKnownTargetingCondition(condition.getKey());
            }
        };
    }
}
