package com.instabug.survey.ui.survey;

import android.text.TextUtils;

import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import com.instabug.survey.models.SurveyTypes;

import java.util.ArrayList;

/**
 * @author mesbah.
 */

public class SurveyFragmentPresenter extends BasePresenter<SurveyFragmentContract.View> implements SurveyFragmentContract.Presenter {

    private Survey survey;

    public SurveyFragmentPresenter(SurveyFragmentContract.View view, Survey survey) {
        super(view);
        this.survey = survey;
    }

    @Override
    public void showSurvey() {
        if (view != null && view.get() != null) {
            SurveyFragmentContract.View viewFragment = view.get();
            if (viewFragment != null)
                viewFragment.showSurvey(survey);
        }
    }

    @Override
    public void handlePowerByFooter() {
        if (view != null) {
            SurveyFragmentContract.View v = view.get();
            if (v != null) {
                v.handlePoweredByFooter();
            }
        }
    }

    public boolean isStoreRatingSurvey(Survey survey) {
        return survey.getType() == SurveyTypes.STORE_RATING;
    }

    public boolean hasValidAnswer(Survey survey, int position) {
        if (isStoreRatingSurvey(survey)) {
            position = survey.isGooglePlayAppRating()? 1: 2;
        }
        ArrayList<Question> questions = survey.getQuestions();
        if(position < questions.size()) {
            try {
                Question question = survey.getQuestions().get(position);
                return !TextUtils.isEmpty(question.getAnswer());
            } catch (Exception exception) {
                IBGDiagnostics.reportNonFatal(exception, "Error while getting question from survey questions list");
                return false;
            }
        }

        return false;
    }
}
