package com.instabug.survey.common.models;


import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.survey.utils.TargetingCondition;
import com.instabug.survey.utils.TargetingOperator;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * @author mesbah
 */

public class Condition implements Cacheable, Serializable {
    // keys used by toJson() & fromJson() methods
    public static final String KEY_KEY = "key";
    private static final String KEY_VALUE = "value";
    private static final String KEY_OPERATOR = "operator";

    @Nullable
    private String key;
    @Nullable
    private String value;
    @Nullable
    private String operator;

    public static JSONArray toJson(ArrayList<Condition> conditions) throws JSONException {
        JSONArray targetAudiencesJsonArray = new JSONArray();
        if (conditions != null) {
            for (int i = 0; i < conditions.size(); i++) {
                targetAudiencesJsonArray.put(new JSONObject(conditions.get(i).toJson()));
            }
        }
        return targetAudiencesJsonArray;
    }

    public static ArrayList<Condition> fromJson(JSONArray targetAudiencesJsonArray) throws JSONException {
        ArrayList<Condition> conditions = new ArrayList<>();
        for (int i = 0; i < targetAudiencesJsonArray.length(); i++) {
            Condition condition = new Condition();
            condition.fromJson(targetAudiencesJsonArray.getJSONObject(i).toString());
            conditions.add(condition);
        }
        return conditions;
    }

    @TargetingCondition
    @Nullable
    public String getKey() {
        return key;
    }

    public Condition setKey(@TargetingCondition String key) {
        this.key = key;
        return this;
    }

    @Nullable
    public String getValue() {
        return value;
    }

    public Condition setValue(String value) {
        this.value = value;
        return this;
    }

    @TargetingOperator
    @Nullable
    public String getOperator() {
        return operator;
    }

    public Condition setOperator(@TargetingOperator String operator) {
        this.operator = operator;
        return this;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject targetAudienceJsonObject = new JSONObject();
        targetAudienceJsonObject.put(KEY_KEY, getKey()).put(KEY_VALUE, value).put(KEY_OPERATOR, operator);
        return targetAudienceJsonObject.toString();
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject targetAudienceJsonObject = new JSONObject(modelAsJson);
        if (targetAudienceJsonObject.has(KEY_KEY))
            setKey(targetAudienceJsonObject.getString(KEY_KEY));
        if (targetAudienceJsonObject.has(KEY_VALUE))
            setValue(targetAudienceJsonObject.getString(KEY_VALUE));
        if (targetAudienceJsonObject.has(KEY_OPERATOR))
            setOperator(targetAudienceJsonObject.getString(KEY_OPERATOR));
    }

    @NonNull
    @Override
    public String toString() {
        return "(key: " + key + ") " + operator + " (value: " + value + ")";
    }
}
