package com.instabug.survey.utils

import android.view.View
import androidx.annotation.RequiresApi
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import androidx.core.view.updatePadding

@RequiresApi(api = 35)
fun View.addSystemWindowInsetToPadding(
    left: Boolean = false,
    top: Boolean = false,
    right: Boolean = false,
    bottom: Boolean = false,
) {
    val initialLeft = paddingLeft
    val initialTop = paddingTop
    val initialRight = paddingRight
    val initialBottom = paddingBottom

    ViewCompat.setOnApplyWindowInsetsListener(this) { view, windowInsets ->
        val insets = windowInsets.getInsets(
            WindowInsetsCompat.Type.systemBars()
                    or WindowInsetsCompat.Type.displayCutout()
                    or WindowInsetsCompat.Type.ime()
        )

        view.updatePadding(
            left = initialLeft + (if (left) insets.left.coerceAtLeast(0) else 0),
            top = initialTop + (if (top) insets.top.coerceAtLeast(0) else 0),
            right = initialRight + (if (right) insets.right.coerceAtLeast(0) else 0),
            bottom = initialBottom + (if (bottom) insets.bottom.coerceAtLeast(0) else 0)
        )
        WindowInsetsCompat.CONSUMED
    }
}

