package com.instabug.survey.utils;

import androidx.annotation.StyleRes;

import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.survey.R;

/**
 * @author hossam.
 */

public class ThemeResolver {
    @StyleRes
    public static int resolveTheme(InstabugColorTheme instabugTheme) {
        if (!InstabugCore.isFeatureEnabled(IBGFeature.CUSTOM_FONT)) {
            if (instabugTheme == InstabugColorTheme.InstabugColorThemeLight) {
                return R.style.InstabugSurveyLight;
            } else {
                return R.style.InstabugSurveyDark;
            }
        } else {
            return getCustomFontTheme(instabugTheme);
        }
    }

    @StyleRes
    private static int getCustomFontTheme(InstabugColorTheme instabugTheme) {
        if (instabugTheme == InstabugColorTheme.InstabugColorThemeLight) {
            return R.style.InstabugSurveyLight_CustomFont;
        } else {
            return R.style.InstabugSurveyDark_CustomFont;
        }
    }

}
