package com.instabug.survey.announcements.ui.fragment.whatsnew;

import android.view.GestureDetector;
import android.view.MotionEvent;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.core.ui.BasePresenter;
import com.instabug.survey.announcements.models.AnnouncementItem;
import com.instabug.survey.ui.gestures.GestureListener;
import com.instabug.survey.ui.gestures.GesturesHandler;

/**
 Created by Barakat on 31/12/2018
 */
public class WhatsNewPresenter extends BasePresenter<WhatsNewContract.View> implements WhatsNewContract.Presenter,
        GesturesHandler.GestureCallback, GestureListener.GesturesCallback {

    @Nullable
    private GestureDetector detector;

    public WhatsNewPresenter(WhatsNewContract.View view) {
        super(view);
    }

    @Override
    public void showWhatsNewAnnouncement(AnnouncementItem announcementItem) {
        WhatsNewContract.View viewRef = this.view.get();
        if (viewRef != null) {
            announcementItem.setHasNoIcons();
            viewRef.showWhatsNewAnnouncement(announcementItem);
        }
    }

    @Override
    public void registerGestureHandler(android.view.View view, MotionEvent event) {
        GesturesHandler.handleAnnouncementView(view, event, this);
        if (detector == null) {
            detector = new GestureDetector(view.getContext(), new GestureListener(this));
        }
        detector.onTouchEvent(event);
    }

    private void handleHardSwipeDown() {
        WhatsNewContract.View viewRef = this.view.get();
        if (viewRef != null) {
            viewRef.dismissAnnouncement();
        }
    }

    @Override
    public void onClick() {

    }

    @Override
    public void close() {
        WhatsNewContract.View viewRef = this.view.get();
        if (viewRef != null) {
            viewRef.dismissAnnouncement();
        }
    }

    @Override
    public void onSwipeRight() { }

    @Override
    public void onSwipeLeft() { }

    @Override
    public void onHardSwipeUp() { }

    @Override
    public void onHardSwipeDown() {
        handleHardSwipeDown();
    }
}
