package com.instabug.survey.utils;

import android.os.Handler;
import android.os.Looper;

import androidx.annotation.Nullable;

import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.Constants;
import com.instabug.survey.settings.SurveysSettings;

public class SurveysUtils {

    public static boolean isKnownTargetingCondition(@Nullable @TargetingCondition String condition) {
        if (condition == null) return false;
        switch (condition) {
            case TargetingCondition.APP_VERSION:
            case TargetingCondition.APP_VERSION_V2:
            case TargetingCondition.DATE:
            case TargetingCondition.USER_EMAIL:
            case TargetingCondition.DAYS_SINCE_DISMISS:
            case TargetingCondition.SESSION_COUNT:
            case TargetingCondition.DAYS_SINCE_SIGN_UP:
            case TargetingCondition.COUNTRY:
            case TargetingCondition.LAST_SEEN:
            case TargetingCondition.OS_API_LEVEL:
                return true;
            default:
                return false;
        }
    }

    public static boolean isSurveysFeatureAvailable() {
        return InstabugCore.isFeatureAvailable(IBGFeature.SURVEYS);
    }

    public static boolean isSurveysFeatureEnabled() {
        return InstabugCore.getFeatureState(IBGFeature.SURVEYS)
                == Feature.State.ENABLED;
    }

    public static void executeRunnableBeforeShowingSurvey() {
        try {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable() {
                @Override
                public void run() {
                    try {
                        if (SurveysSettings.getOnShowCallback() != null) {
                            SurveysSettings.getOnShowCallback().onShow();
                        }
                    } catch (Exception e) {
                        InstabugSDKLogger.e(Constants.LOG_TAG, "AfterShowingSurveyRunnable " +
                                "has been failed to run.", e);
                    }
                }
            });
        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "AfterShowingSurveyRunnable " +
                    "has been failed to run.", e);
        }
    }

    public static void executeRunnableAfterShowingSurvey() {
        try {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable() {
                @Override
                public void run() {
                    try {
                        if (SurveysSettings.getOnDismissCallback() != null) {
                            SurveysSettings.getOnDismissCallback().onDismiss();
                        }
                    } catch (Exception e) {
                        InstabugSDKLogger.e(Constants.LOG_TAG, "AfterShowingSurveyRunnable " +
                                "has been failed to run.", e);
                    }
                }
            });
        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "AfterShowingSurveyRunnable " +
                    "has been failed to run.", e);
        }
    }
}
