package com.instabug.survey.ui.survey.welcomepage;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;

import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.survey.R;
import com.instabug.survey.models.Survey;
import com.instabug.survey.ui.SurveyNavigator;
import com.instabug.survey.utils.TextSizeCalculator;

import org.jetbrains.annotations.NotNull;

/**
 * Created by mohamedzakaria on 8/29/17.
 */

public abstract class WelcomeAbstractFragment extends InstabugBaseFragment<WelcomeFragmentPresenter>
        implements WelcomeFragmentContract.View, View.OnClickListener {
    public static final String KEY_SURVEY = "survey";

    @Nullable
    private Button takeSurvey;
    @Nullable
    protected Survey survey;
    @Nullable
    protected TextView title;
    @Nullable
    private TextView subtitle;

    public static WelcomeAbstractFragment newInstance(Survey survey) {
        Bundle args = new Bundle();
        args.putSerializable(KEY_SURVEY, survey);
        WelcomeAbstractFragment fragment = new WelcomeFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            survey = (Survey) getArguments().getSerializable(KEY_SURVEY);
        }
        presenter = new WelcomeFragmentPresenter(this);
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_survey_fragment_welcome_dialog;
    }

    @Override
    @CallSuper
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        Button takeSurveyButton = takeSurvey = findViewById(R.id.ib_welcome_survey_take_survey);
        title = findViewById(R.id.ib_welcome_survey_title);
        subtitle = findViewById(R.id.ib_welcome_survey_text);

        if (getContext() == null) return;

        if (takeSurveyButton != null) {
            takeSurveyButton.setOnClickListener(this);
            takeSurveyButton.setTextColor(ContextCompat.getColor(requireContext(), android.R.color.white));
            DrawableUtils.setColor(takeSurveyButton, getTakeSurveyButtonColor());
        }
        addCustomPlaceHolders();
    }

    protected abstract int getTakeSurveyButtonColor();

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    private void addCustomPlaceHolders() {
        if (title != null) {
            title.setText(PlaceHolderUtils.getPlaceHolder(
                    InstabugCustomTextPlaceHolder.Key.SURVEYS_WELCOME_SCREEN_TITLE,
                    getLocalizedString(R.string.instabug_survey_welcome_feedback)));
        }
        if (subtitle != null) {
            subtitle.setText(PlaceHolderUtils.getPlaceHolder(
                    InstabugCustomTextPlaceHolder.Key.SURVEYS_WELCOME_SCREEN_SUBTITLE,
                    getLocalizedString(R.string.instabug_survey_welcome_feedback_msg)));
        }
        if (takeSurvey != null) {
            takeSurvey.setText(PlaceHolderUtils.getPlaceHolder(
                    InstabugCustomTextPlaceHolder.Key.SURVEYS_WELCOME_SCREEN_BUTTON,
                    getLocalizedString(R.string.instabug_survey_welcome_button)));
        }
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (presenter != null) presenter.handlePoweredByFooter();
    }

    @Override
    public void handlePoweredByFooter() {
        if (getActivity() == null || rootView == null)
            return;

        InstabugCore.handlePbiFooter(rootView);
        InstabugCore.handlePbiFooterThemeColor(
                rootView,
                R.color.pbi_footer_color_dark,
                R.color.pbi_footer_color_light
        );
    }

    @Override
    public void updateButtonText(String buttonText) {
        if (takeSurvey != null)
            takeSurvey.setText(buttonText);
    }

    @Override
    public void updateSubtitle(String subtitle) {
        if (this.subtitle != null)
            this.subtitle.setText(subtitle);
    }

    @Override
    public void updateTitle(String title) {
        if (this.title != null)
            this.title.setText(title);
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.ib_welcome_survey_take_survey) {
            handleTakeSurveyButtonClicked();
        }
    }

    @Override
    public void handleDismissButtonClicked() {
        //Fix codecy UncommentedEmptyMethodBody warning.
    }

    @Override
    public void handleTakeSurveyButtonClicked() {
        if (getActivity() == null) return;
        Survey currentSurvey = survey;
        if (currentSurvey == null) return;
        if (getActivity().getSupportFragmentManager() == null) return;

        Fragment fragment = getActivity().getSupportFragmentManager()
                .findFragmentById(R.id.instabug_fragment_container);
        if (fragment != null) {
            getActivity().getSupportFragmentManager()
                    .beginTransaction()
                    .setCustomAnimations(0, 0)
                    .remove(fragment)
                    .commit();
        }
        SurveyNavigator.navigateToSurveyFromWelcomeScreen(getActivity().getSupportFragmentManager(), currentSurvey);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (title != null)
            TextSizeCalculator.resize(title);
    }
}
