package com.instabug.survey.ui.survey.thankspage;

import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.SURVEYS_STORE_RATING_THANKS_SUBTITLE;
import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.SURVEYS_STORE_RATING_THANKS_TITLE;

import androidx.annotation.Nullable;

import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.survey.R;
import com.instabug.survey.models.Survey;
import com.instabug.survey.models.SurveyTypes;

/**
 * Created by mohamedzakaria on 8/29/17.
 */

class ThanksFragmentPresenter extends BasePresenter<ThanksFragmentContract.View>
        implements ThanksFragmentContract.Presenter {
    public ThanksFragmentPresenter(ThanksFragmentContract.View view) {
        super(view);
    }


    @Override
    public void handlePoweredByFooter() {
        if (view != null) {
            ThanksFragmentContract.View v = view.get();
            if (v != null) {
                v.handlePoweredByFooter();
            }
        }
    }

    @Nullable
    public String getTitle(Survey survey) {
        ThanksFragmentContract.View viewRef = this.view.get();
        if (viewRef != null && survey != null) {
            switch (survey.getType()) {
                case SurveyTypes.CUSTOM:
                    // set from SDK or dashboard
                    String thankYouTitle = survey.getThankYouTitle();
                    return thankYouTitle != null ? thankYouTitle : "";
                case SurveyTypes.NPS:
                    // set from dashboard
                    return survey.getThankYouTitle();
                case SurveyTypes.STORE_RATING:
                    // set from SDK
                    String ratingDefaultValue = viewRef.getLocalizedString(R.string.instabug_store_rating_survey_thanks_title);
                    return PlaceHolderUtils.getPlaceHolder(SURVEYS_STORE_RATING_THANKS_TITLE, ratingDefaultValue);
                default:
                    return "";
            }
        }
        return "";
    }

    @Nullable
    public String getMessage(Survey survey) {
        ThanksFragmentContract.View viewRef = this.view.get();
        if (viewRef != null && survey != null) {
            switch (survey.getType()) {
                case SurveyTypes.CUSTOM:
                    // set from SDK or dashboard
                    String thankYouMessage = survey.getThankYouMessage();
                    return thankYouMessage != null ? thankYouMessage : "";
                case SurveyTypes.NPS:
                    // set from dashboard
                    return survey.getThankYouMessage();
                case SurveyTypes.STORE_RATING:
                    // set from SDK
                    String ratingDefaultValue = viewRef.getLocalizedString(R.string.instabug_store_rating_survey_thanks_subtitle);
                    return PlaceHolderUtils.getPlaceHolder(SURVEYS_STORE_RATING_THANKS_SUBTITLE, ratingDefaultValue);
            }
        }
        return "";
    }
}
