package com.instabug.survey.ui.survey.mcq;

import android.os.Bundle;
import android.view.View;
import android.widget.GridView;
import android.widget.Toast;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.ui.survey.QuestionFragment;
import com.instabug.survey.ui.survey.SurveyFragmentCallbacks;

import org.jetbrains.annotations.NotNull;

/**
 * Created by mohamedzakaria on 7/19/17.
 */

public class MCQQuestionAbstractFragment extends QuestionFragment implements SurveyMCQGridAbstractAdapter.AnswerOnClickListener {
    @VisibleForTesting
    @Nullable
    protected SurveyMCQGridAbstractAdapter surveyMCQGridAdapter;
    @Nullable
    protected GridView optionalAnswersGridView;

    @Override
    protected int getLayout() {
        return R.layout.instabug_dialog_mcq_survey;
    }


    public static MCQQuestionAbstractFragment newInstance(boolean shouldChangeContainerHeight, Question question, SurveyFragmentCallbacks surveyFragmentCallbacks) {
        Bundle args = new Bundle();
        args.putSerializable(KEY_QUESTION_ARGUMENT, question);
        args.putBoolean(KEY_SHOULD_CHANGE_CONTAINER_HEIGHT_ARGUMENT, shouldChangeContainerHeight);
        MCQQuestionAbstractFragment fragment = new MCQQuestionFragment();
        fragment.setArguments(args);
        fragment.setSurveyFragmentCallbacks(surveyFragmentCallbacks);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
        if (getArguments() != null)
            question = (Question) getArguments().getSerializable(KEY_QUESTION_ARGUMENT);
    }

    @Override
    @CallSuper
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        super.initViews(rootView, savedInstanceState);
        questionTextView = rootView.findViewById(R.id.instabug_text_view_question);
        optionalAnswersGridView = rootView.findViewById(R.id.instabug_survey_mcq_grid_view);

        handleTextViewMaxLines();
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        view.setFocusableInTouchMode(true);
        if (question != null) showMcqQuestion(question);
    }

    public void showMcqQuestion(Question question) {
        if (question == null || getActivity() == null || questionTextView == null) return;
        if (question.getTitle() != null) {
            questionTextView.setText(question.getTitle());
        }

        surveyMCQGridAdapter = new SurveyMCQGridAdapter(getActivity(), question, this);
        if (optionalAnswersGridView != null) {
            optionalAnswersGridView.setAdapter(surveyMCQGridAdapter);
        }
        surveyMCQGridAdapter.setAnswer(question.getAnswer());
    }

    @Nullable
    public String getAnswer() {
        if (surveyMCQGridAdapter != null) {
            if (surveyMCQGridAdapter.getCurrentAnswer() != null) {
                return surveyMCQGridAdapter.getCurrentAnswer();
            }
        }
        if (getContext() != null) {
            Toast.makeText(getContext(), getLocalizedString(R.string.instabug_str_error_survey_without_answer),
                    Toast.LENGTH_SHORT).show();
        }
        return null;
    }

    @Override
    public void onAnswerClicked(View v, String answer) {
        if (question == null) return;

        question.setAnswer(answer);
        if (surveyFragmentCallbacks != null) {
            surveyFragmentCallbacks.onAnswerMCQQuestion(question);
        }
    }

    @VisibleForTesting
    @Nullable
    Question getQuestion() {
        return question;
    }

}
