package com.instabug.survey.ui.custom

import android.graphics.Rect
import android.os.Bundle
import android.view.View
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat.ACTION_CLICK
import androidx.customview.widget.ExploreByTouchHelper
import com.instabug.survey.R

class CustomExploreByTouchHelper(private val provider: VirtualViewsInfoProvider) :
    ExploreByTouchHelper(provider.view) {


    private val actionClick by lazy {
        val selectTxt = provider.view.resources.getString(R.string.ib_action_select)
        AccessibilityNodeInfoCompat.AccessibilityActionCompat(ACTION_CLICK, selectTxt)
    }

    override fun getVirtualViewAt(x: Float, y: Float): Int = provider.getPositionAt(x, y)

    override fun getVisibleVirtualViews(virtualViewIds: MutableList<Int>?) {
        virtualViewIds?.addAll(provider.getVirtualViews())
    }

    override fun onPopulateNodeForVirtualView(
        virtualViewId: Int,
        node: AccessibilityNodeInfoCompat
    ) {
        provider.populateNodeForVirtualView(virtualViewId, node)
        node.apply {
            addAction(actionClick)
            isImportantForAccessibility = true
            isFocusable = true
        }

    }

    override fun onPerformActionForVirtualView(
        virtualViewId: Int,
        action: Int,
        arguments: Bundle?
    ): Boolean = if (action == ACTION_CLICK) {
        provider.onClickActionForPosition(virtualViewId)
        true
    } else
        false

}

interface VirtualViewsInfoProvider {
    val view: View
    fun getPositionAt(x: Float, y: Float): Int
    fun getVirtualViews(): List<Int>
    fun populateNodeForVirtualView(
        position: Int,
        info: AccessibilityNodeInfoCompat
    )

    fun onClickActionForPosition(position: Int)

}


interface ChildViewsProvider {
    fun childPositionAt(x: Float, y: Float): Int
    fun childBoundsAtPosition(position: Int): Rect?
}