package com.instabug.survey.ui;

import androidx.appcompat.app.AppCompatActivity;

import com.instabug.library.core.ui.BaseContract;
import com.instabug.survey.models.Survey;

/**
 * Created by zak on 1/4/18.
 */

public interface SurveyActivityContract {
    interface View extends BaseContract.View<AppCompatActivity> {

        void setFrameLayoutHeightTo(int height);

        void finishSurvey(boolean showThanksFragment);

        void finishNPSSurvey(boolean withoutDelay);

        void setFrameLayoutHeightWithAnimation(int heightInPx);
    }

    interface Presenter {

        void setLayoutHeightSecondary(ViewType viewType, boolean withAnimation);

        void handleOnBackPressedLogic();

        void submitSurvey(Survey survey);

        void dismissSurvey(Survey survey);
    }
}

