package com.instabug.survey.network;

import android.content.Context;

import androidx.annotation.Nullable;

import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.TimeUtils;
import com.instabug.survey.Constants;
import com.instabug.survey.announcements.settings.AnnouncementsSettings;
import com.instabug.survey.models.CountryInfo;
import com.instabug.survey.network.service.SurveysService;
import com.instabug.survey.settings.SurveysSettings;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Barakat on 08/01/2019
 * A service to resolve location information (Country/City) through the device IP
 */
public class CountryInfoResolver {


    private CountryInfoResolverCallback callback;

    public CountryInfoResolver(CountryInfoResolverCallback callback) {
        this.callback = callback;
    }

    public void resolveCountryCode(final Context context) throws JSONException {
        SurveysService.getInstance().resolveCountryInfo(new Request.Callbacks<JSONObject, Throwable>() {
                    @Override
                    public void onSucceeded(@Nullable JSONObject response) {
                        if (response != null) {
                            InstabugSDKLogger.d(Constants.LOG_TAG, "resolveCountryCode succeed");
                            CountryInfo countryInfo = new CountryInfo();
                            try {
                                countryInfo.fromJson(response.toString());
                                callback.onSuccess(countryInfo);
                                SurveysSettings.setCountryInfoLastFetch(TimeUtils.currentTimeMillis());
                                AnnouncementsSettings.setCountryInfoLastFetch(TimeUtils.currentTimeMillis());
                            } catch (JSONException error) {
                                error.printStackTrace();
                                callback.onError(error);
                            }
                        } else {
                            InstabugSDKLogger.e(Constants.LOG_TAG, "resolveCountryCode succeed: but response is null");
                        }
                    }

                    @Override
                    public void onFailed(Throwable error) {
                        callback.onError(error);
                    }
                });
    }

    public interface CountryInfoResolverCallback {
        void onSuccess(CountryInfo countryInfo);

        void onError(Throwable error);
    }
}
