package com.instabug.survey.configuration

import com.instabug.survey.preferences.surveysPreferences

interface SurveysConfigurationsProvider {
    var isSurveysAvailable: Boolean
    var isAnnouncementsAvailable: Boolean
    var isSurveysUsageExceeded: Boolean
    val isSurveysAvailableAndUsageNotExceeded: Boolean
}

object SurveysConfigurationsProviderImpl : SurveysConfigurationsProvider {
    private const val DEFAULT_FEATURE_AVAILABILITY = true
    private const val DEFAULT_EXCEEDING_USAGE = false
    private const val SURVEYS_AVAILABILITY_KEY = "surveys_availability"
    private const val ANNOUNCEMENTS_AVAILABILITY_KEY = "announcements_availability"
    private const val SURVEYS_USAGE_EXCEEDED_KEY = "surveys_usage_exceeded"

    private val sharedPreferences
        get() = surveysPreferences
    private val editor
        get() = sharedPreferences?.edit()

    override var isSurveysAvailable: Boolean
        get() = sharedPreferences?.getBoolean(
            SURVEYS_AVAILABILITY_KEY,
            DEFAULT_FEATURE_AVAILABILITY
        ) ?: DEFAULT_FEATURE_AVAILABILITY
        set(value) {
            editor
                ?.putBoolean(SURVEYS_AVAILABILITY_KEY, value)
                ?.apply()
        }

    override var isAnnouncementsAvailable: Boolean
        get() = sharedPreferences?.getBoolean(
            ANNOUNCEMENTS_AVAILABILITY_KEY,
            DEFAULT_FEATURE_AVAILABILITY
        ) ?: DEFAULT_FEATURE_AVAILABILITY
        set(value) {
            editor
                ?.putBoolean(ANNOUNCEMENTS_AVAILABILITY_KEY, value)
                ?.apply()
        }

    override var isSurveysUsageExceeded: Boolean
        get() = sharedPreferences?.getBoolean(SURVEYS_USAGE_EXCEEDED_KEY, DEFAULT_EXCEEDING_USAGE)
            ?: DEFAULT_EXCEEDING_USAGE
        set(value) {
            editor
                ?.putBoolean(SURVEYS_USAGE_EXCEEDED_KEY, value)
                ?.apply()
        }
    override val isSurveysAvailableAndUsageNotExceeded: Boolean
        get() = isSurveysAvailable && !isSurveysUsageExceeded

}