package com.instabug.survey.common.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BaseLocalization implements Serializable {
    private static final String KEY_LOCALIZED = "localized";
    private static final String KEY_LOCALES = "locales";
    private static final String KEY_CURRENT_LOCALE = "current_locale";

    private boolean isLocalized;
    @Nullable
    private List<String> locales;
    @Nullable
    private String currentLocale;

    public BaseLocalization() {
        isLocalized = false;
    }

    public void localizationToJson(JSONObject surveyJsonObject) throws JSONException {
        if (surveyJsonObject == null)
            return;

        surveyJsonObject.put(KEY_LOCALIZED, isLocalized);
        if (locales != null) surveyJsonObject.put(KEY_LOCALES, locales);
        if (currentLocale != null) surveyJsonObject.put(KEY_CURRENT_LOCALE, currentLocale);

    }


    public void localizationFromJson(JSONObject surveyJsonObject) throws JSONException {
        setLocalized(surveyJsonObject.optBoolean(KEY_LOCALIZED, false));
        setCurrentLocale(surveyJsonObject.optString(KEY_CURRENT_LOCALE));
        if (surveyJsonObject.has(KEY_LOCALES)) {
            JSONArray jsonArray = surveyJsonObject.getJSONArray(KEY_LOCALES);
            setLocaleFromJson(jsonArray);
        }
    }

    public void setLocaleFromJson(JSONArray localJsonArray) throws JSONException {
        List<String> locals = new ArrayList<>();
        for (int i = 0; i < localJsonArray.length(); i++) {
            locals.add(localJsonArray.getString(i));
        }
        setLocales(locals);
    }

    public String getLocalAsArrayJson(List<String> locales) {
        return new JSONArray(locales).toString();
    }

    public void setCurrentLocale(@Nullable String currentLocale) {
        this.currentLocale = currentLocale;
    }

    @Nullable
    public String getCurrentLocale() {
        return currentLocale;
    }

    public void setLocalized(boolean localized) {
        isLocalized = localized;
    }

    public boolean isLocalized() {
        return isLocalized;
    }

    public void setLocales(@NonNull List<String> locales) {
        this.locales = locales;
    }

    @NonNull
    public List<String> getLocales() {
        return locales == null ? Collections.<String>emptyList() : locales;
    }
}
