package com.instabug.survey.announcements.ui.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.widget.Toast;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.URLUtil;
import com.instabug.survey.R;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.models.AnnouncementType;
import com.instabug.survey.announcements.ui.fragment.versionupdate.UpdateMessageFragment;
import com.instabug.survey.announcements.ui.fragment.whatsnew.WhatsNewFragment;

public class AnnouncementNavigator {

    public static void navigateToAnnouncement(FragmentManager fragmentManager, Announcement announcement) {
        switch (announcement.getType()) {
            case AnnouncementType.UPDATE_MSG:
                showUpdateMessageFragment(fragmentManager, announcement);
                break;
            case AnnouncementType.WHAT_IS_NEW:
                showWhatsNewFragment(fragmentManager, announcement, R.anim.instabug_anim_flyin_from_bottom,
                        R.anim.instabug_anim_flyout_to_bottom);
                break;
            default:
                break;
        }
    }

    private static void showWhatsNewFragment(FragmentManager fragmentManager, Announcement announcement, int enterAnimation, int exitAnimation) {
        if (announcement.getAnnouncementItems() != null) {
            navigateToFragment(fragmentManager, WhatsNewFragment.newInstance(announcement.getAnnouncementItems().get(0)), enterAnimation, exitAnimation);
        }
    }

    private static void showUpdateMessageFragment(FragmentManager fragmentManager, Announcement announcement) {
        if (announcement.getAnnouncementItems() != null) {
            navigateToFragment(fragmentManager, UpdateMessageFragment.newInstance(announcement.getAnnouncementItems().get(0)), 0, 0);
        }
    }

    public static void navigateToFragment(FragmentManager fragmentManager, Fragment fragment,
                                          int enterAnimation, int exitAnimation) {
        fragmentManager.beginTransaction()
                .setCustomAnimations(enterAnimation, exitAnimation)
                .replace(R.id.instabug_fragment_container, fragment)
                .commit();
    }

    public static void navigateToExternalBrowser(Context context, String androidLink) {
        if (context != null) {
            androidLink = URLUtil.resolve(androidLink);
            if (androidLink == null) {
                showToast(context, LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(context), R.string.ib_announcement_redirect_error, context));
            } else {
                Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(androidLink));
                if (intent.resolveActivity(context.getPackageManager()) != null) {
                    context.startActivity(intent);
                } else {
                    showToast(context, LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(context), R.string.ib_announcement_redirect_error, context));
                }
            }
        }
    }

    private static void showToast(Context context, String message) {
        Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
    }
}
