package com.instabug.survey.announcements.models;

import androidx.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

public class DownloadLink implements Serializable {

    private static final String KEY_ANDROID = "android";
    @Nullable
    private String androidLink;

    @Nullable
    public static DownloadLink fromJson(@Nullable JSONObject downloadLinkJsonObject) {
        if (downloadLinkJsonObject == null)
            return null;
        DownloadLink downloadLink = new DownloadLink();
        downloadLink.setAndroidLink(downloadLinkJsonObject.optString(KEY_ANDROID));
        return downloadLink;
    }

    @Nullable
    public String getAndroidLink() {
        return androidLink;
    }

    public void setAndroidLink(@Nullable String androidLink) {
        this.androidLink = androidLink;
    }

    public static JSONObject toJson(DownloadLink downloadLink) throws JSONException {
        JSONObject downloadLinkJsonObject = new JSONObject();
        if (downloadLink != null && downloadLink.getAndroidLink() != null) {
            downloadLinkJsonObject.put(KEY_ANDROID, downloadLink.getAndroidLink());
        }

        return downloadLinkJsonObject;
    }

}
