package com.instabug.survey.announcements.models;

import androidx.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;


public class AnnouncementConfig implements Serializable {

    private static final String KEY_DOWNLOAD_LINKS = "download_links";

    @Nullable
    private DownloadLink downloadLink;

    @Nullable
    public DownloadLink getDownloadLink() {
        return downloadLink;
    }

    public void setDownloadLink(@Nullable DownloadLink downloadLink) {
        this.downloadLink = downloadLink;
    }


    public static JSONObject toJson(@Nullable AnnouncementConfig announcementConfig) throws JSONException {
        JSONObject announcementJsonObject = new JSONObject();
        if (announcementConfig != null && announcementConfig.getDownloadLink() != null) {
            announcementJsonObject
                    .put(KEY_DOWNLOAD_LINKS,
                            DownloadLink.toJson(announcementConfig.getDownloadLink()));

        }


        return announcementJsonObject;
    }

    @Nullable
    public static AnnouncementConfig fromJson(JSONObject jsonObject) {
        if (jsonObject == null)
            return null;
        AnnouncementConfig announcementConfig = new AnnouncementConfig();
        try {
            announcementConfig.setDownloadLink(DownloadLink.fromJson(jsonObject.getJSONObject(KEY_DOWNLOAD_LINKS)));
        } catch (JSONException e) {
            return announcementConfig;
        }
        return announcementConfig;
    }
}
