package com.instabug.survey.announcements.cache;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;

import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.models.AnnouncementType;

import java.util.List;

/**
 * Created by Barakat on 25/12/2018
 */
@WorkerThread
public class AnnouncementCacheManager {

    public static void addAnnouncements(List<Announcement> announcements) {
        for (Announcement announcement : announcements) {
            if (!isAnnouncementExist(announcement.getId())) {
                addAnnouncement(announcement);
            }
        }
    }

    public static void addAnnouncement(Announcement announcement) {
        AnnouncementsDBHelper.insert(announcement);
    }

    public static void insertOrUpdatePausedOrLocale(final Announcement survey,
                                                    final boolean isPublishStateChanged,
                                                    final boolean isLocaleChanged) {
        PoolProvider.postIOTask(new Runnable() {
            @Override
            public void run() {
                AnnouncementsDBHelper.insertOrUpdatePausedOrLocale(survey, isPublishStateChanged,
                        isLocaleChanged);
            }
        });
    }

    public static List<Announcement> getAnnouncementsByType(@AnnouncementType int announcementType) {
        return AnnouncementsDBHelper.retrieveByType(announcementType);
    }

    public static List<Announcement> getReadyToBeSend() {
        return AnnouncementsDBHelper.retrieveReadyToBeSend();
    }

    public static List<Announcement> getAllAnnouncement() {
        return AnnouncementsDBHelper.retrieve();
    }

    public static void updateAnnouncement(final Announcement announcement) {
        AnnouncementsDBHelper.update(announcement);
    }

    public static void deleteAnnouncement(String id) {
        AnnouncementsDBHelper.delete(id);
    }

    public static void deleteAllAnnouncement() {
        AnnouncementsDBHelper.deleteAll();
    }

    public static boolean isAnnouncementExist(long id) {
        return AnnouncementsDBHelper.isExisting(id);
    }

    @Nullable
    public static Announcement getAnnouncement(long id) {
        return AnnouncementsDBHelper.retrieveById(id);
    }

    public static long insertAnnouncementAsset(long announceId, long id, String filePath) {
        return AnnouncementAssetsDBHelper.insert(announceId, id, filePath);
    }

    @Nullable
    public static String getAnnouncementAsset(long announceId, long id) {
        return AnnouncementAssetsDBHelper.retrieveAssetsPathOf(announceId, id);
    }

    public static void deleteAnnouncementAssets() {
        AnnouncementAssetsDBHelper.delete();
    }

    public static void resetAnnouncementUserInteraction(List<Announcement> announcements) {
        for (Announcement announcement : announcements) {
            announcement.resetUserInteractions();
        }
        AnnouncementsDBHelper.updateBulk(announcements);
    }

    public static void updateBulk(final List<Announcement> announcements) {
        AnnouncementsDBHelper.updateBulk(announcements);
    }

    public static void updateAssetStatus(final long announcementId, final int downloadSucceed) {
        AnnouncementsDBHelper.updateAssetStatus(announcementId, downloadSucceed);
    }
}
