package com.instabug.survey.ui.survey.nps;

import android.os.Bundle;
import android.view.View;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;

import com.instabug.library.util.AccessibilityUtils;
import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.ui.custom.NpsView;
import com.instabug.survey.ui.survey.QuestionFragment;
import com.instabug.survey.ui.survey.SurveyFragmentCallbacks;

import org.jetbrains.annotations.NotNull;

/**
 * Created by mohamedzakaria on 8/15/17.
 */

public abstract class NPSAbstractQuestionFragment extends QuestionFragment implements NpsView.OnNpsSelectionListener {
    @Nullable
    protected NpsView npsLayout;

    public static NPSQuestionFragment newInstance(boolean shouldChangeContainerHeight, Question question, SurveyFragmentCallbacks surveyFragmentCallbacks) {
        NPSQuestionFragment questionFragment = new NPSQuestionFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean(KEY_SHOULD_CHANGE_CONTAINER_HEIGHT_ARGUMENT, shouldChangeContainerHeight);
        bundle.putSerializable(KEY_QUESTION_ARGUMENT, question);
        questionFragment.setArguments(bundle);
        questionFragment.setSurveyFragmentCallbacks(surveyFragmentCallbacks);
        return questionFragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
        if (getArguments() != null)
            question = (Question) getArguments().getSerializable(KEY_QUESTION_ARGUMENT);
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_dialog_nps_survey;
    }

    @Override
    @CallSuper
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        super.initViews(rootView, savedInstanceState);
        npsLayout = (NpsView) rootView.findViewById(R.id.instabug_survey_nps_layout);
        if (AccessibilityUtils.isTalkbackEnabled()
                && questionTextView != null && questionTextView.getContentDescription() != null) {
            String fullAnnouncement = questionTextView.getContentDescription()
                    + " " + getString(R.string.ibg_surveys_nps_less_likely_content_description)
                    + ". " + getString(R.string.ibg_surveys_nps_very_likely_content_description);
            if (questionTextView != null) {
                questionTextView.setContentDescription(fullAnnouncement);
            }
        }
        if (npsLayout != null) {
            npsLayout.setOnSelectionListener(this);
        }
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        showNPSQuestion(question);
    }

    void showNPSQuestion(@Nullable Question question) {
        if (question == null) return;
        if (questionTextView != null && question.getTitle() != null) {
            questionTextView.setText(getQuestionTitle(question.getTitle()));
        }
        if (npsLayout != null && question.getAnswer() != null && question.getAnswer().length() > 0) {
            npsLayout.setScore(Integer.parseInt(question.getAnswer()));
        }
    }

    protected String getQuestionTitle(String questionTitle) {
        return questionTitle;
    }

    @Override
    @Nullable
    public String getAnswer() {
        if (question == null) return null;
        return question.getAnswer();
    }

    @Nullable
    public Question getQuestion() {
        return question;
    }

    @Override
    public void onScoreSelected(int score) {
        if (question == null) return;
        question.setAnswer(String.valueOf(score));
        if (surveyFragmentCallbacks != null) {
            surveyFragmentCallbacks.onAnswerNPSQuestion(question);
        }
    }
}
