package com.instabug.survey.ui.popup;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.instabug.library.core.ui.BaseContract;
import com.instabug.survey.models.Survey;

/**
 * Created by Barakat on 06/01/2019
 */

public interface PopupQuestionContract {

    interface View extends BaseContract.View<Fragment> {

        void onBetaAppPrimaryQuestionAnswered(Survey survey);

        void onPositiveSecondaryQuestionNegativeResponse(Survey survey);

        void onPositiveSecondaryQuestionPositiveResponse(Survey survey);

        void showNegativeSecondaryQuestion(Survey survey);

        void showPrimaryQuestion(@Nullable String title, @Nullable String message, String positiveCTA, String negativeCTA);

        void showAlertForPositiveSecondaryQuestion(@Nullable String title, @Nullable String message, String positiveCTA, String negativeCTA);

        void dismissSurvey(Survey survey);

        void submitSurvey(Survey survey);
    }

    interface Presenter extends BaseContract.Presenter {
        void showPrimaryQuestion();

        void showPositiveSecondaryQuestion();

        void showNegativeSecondaryQuestion();

        void showGooglePlayInAppRating();

        void dismissSurvey();

        void submitSurvey();
    }
}
