package com.instabug.survey.ui.popup;

import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;

import com.instabug.library.ui.custom.InstabugAlertDialog;
import com.instabug.survey.models.Survey;

public class PopupPublicQuestionFragment extends PopupQuestionFragment {
    public static PopupPublicQuestionFragment newInstance(Survey survey) {

        Bundle args = new Bundle();
        args.putSerializable(KEY_SURVEY_ARGUMENT, survey);
        PopupPublicQuestionFragment fragment = new PopupPublicQuestionFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void showPrimaryQuestion(@Nullable String title, @Nullable String message, String positiveCTA, String negativeCTA) {
        FragmentActivity activity = getActivity();
        if (activity != null) {
            new InstabugAlertDialog.Builder(activity)
                    .setTitle(title)
                    .setMessage(message)
                    .setCancellable(false)
                    .setPositiveButton(positiveCTA, (dialogInterface, i) -> {
                        if (presenter != null) {
                            presenter.positivePrimaryOptionClicked();
                        }
                    })
                    .setNegativeButton(negativeCTA, (dialogInterface, i) -> {
                        if (presenter != null) {
                            presenter.showNegativeSecondaryQuestion();
                        }
                    })
                    .show();
        }
    }

    @Override
    public void showAlertForPositiveSecondaryQuestion(@Nullable String title, @Nullable String message, String positiveCTA, String negativeCTA) {
        FragmentActivity activity = getActivity();
        if (activity != null) {
            new InstabugAlertDialog.Builder(activity)
                    .setTitle(title)
                    .setMessage(message)
                    .setCancellable(false)
                    .setPositiveButton(positiveCTA, (dialogInterface, i) -> {
                        if (presenter != null) {
                            presenter.positiveSecondaryOptionClicked();
                        }
                    })
                    .setNegativeButton(negativeCTA, (dialogInterface, i) -> {
                        if (presenter != null) {
                            presenter.negativeSecondaryOptionClicked();
                        }
                    })
                    .show();
        }
    }

}
