package com.instabug.survey.models;


import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.Constants;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Barakat on 08/01/2019
 */
public class CountryInfo implements Cacheable {

    private static final String KEY_COUNTRY = "country";
    private static final String KEY_COUNTRY_CODE = "country_code";
    private static final String KEY_CITY = "city";
    private static final String KEY_TTL = "ttl";

    @Nullable
    private String country;
    @Nullable
    private String countryCode;
    @Nullable
    private String city;
    private long ttl = -1;

    public CountryInfo() {
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(KEY_COUNTRY, getCountry())
                .put(KEY_COUNTRY_CODE, getCountryCode())
                .put(KEY_CITY, getCity())
                .put(KEY_TTL, getTtl());
        return jsonObject.toString();
    }

    @Nullable
    public String getCountry() {
        return country;
    }

    public void setCountry(@NonNull String country) {
        this.country = country;
    }

    @Nullable
    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(@NonNull String countryCode) {
        this.countryCode = countryCode;
    }

    @Nullable
    public String getCity() {
        return city;
    }

    public void setCity(@NonNull String city) {
        this.city = city;
    }

    public long getTtl() {
        return ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject jsonObject = new JSONObject(modelAsJson);
        setCountry(jsonObject.optString(KEY_COUNTRY));
        setCountryCode(jsonObject.optString(KEY_COUNTRY_CODE));
        setCity(jsonObject.optString(KEY_CITY));
        setTtl(jsonObject.optLong(KEY_TTL));
    }

    @NonNull
    @Override
    public String toString() {
        try {
            return toJson();
        } catch (JSONException e) {
            if (e.getMessage() != null) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Error: " + e.getMessage() + " while parsing country info", e);
            }
        }
        return super.toString();
    }
}
