/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.models;

import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FeatureRequest
implements Cacheable,
Serializable {
    public static final String KEY_ID = "id";
    public static final String KEY_TITLE = "title";
    public static final String KEY_DESCRIPTION = "description";
    public static final String KEY_STATUS = "status";
    public static final String KEY_LIKES_COUNT = "likes_count";
    public static final String KEY_COMMENTS_COUNT = "comments_count";
    public static final String KEY_IS_LIKED = "liked";
    public static final String KEY_DATE = "date";
    public static final String KEY_COLOR_CODE = "color_code";
    public static final String KEY_CREATOR_NAME = "creator_name";
    private static final String KEY_VOTE_UPDATED = "ib_user_vote_status";
    private long featureId;
    private String title;
    private String description;
    private a status;
    private String colorCode;
    private String creatorName;
    private long date;
    private int likesCount;
    private int commentsCount;
    private boolean isLiked;
    private b userVoteStatus = b.NOTHING;

    public static List<FeatureRequest> fromJson(JSONArray jSONArray) throws JSONException {
        ArrayList<FeatureRequest> arrayList = new ArrayList<FeatureRequest>();
        for (int k = 0; k < jSONArray.length(); ++k) {
            JSONObject jSONObject = jSONArray.getJSONObject(k);
            FeatureRequest featureRequest = new FeatureRequest();
            featureRequest.fromJson(jSONObject.toString());
            arrayList.add(featureRequest);
        }
        return arrayList;
    }

    public static FeatureRequest fromJson(JSONObject jSONObject) throws JSONException {
        FeatureRequest featureRequest = new FeatureRequest();
        featureRequest.fromJson(jSONObject.toString());
        return featureRequest;
    }

    public FeatureRequest() {
        this.status = a.Open;
        this.featureId = System.currentTimeMillis() / 1000L;
    }

    public long getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(long l) {
        this.featureId = l;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string2) {
        this.title = string2;
    }

    public a getStatus() {
        return this.status;
    }

    public void setStatus(a a2) {
        this.status = a2;
    }

    public int getLikesCount() {
        return this.likesCount;
    }

    public void setLikesCount(int n) {
        this.likesCount = n;
    }

    public int getCommentsCount() {
        return this.commentsCount;
    }

    public void setCommentsCount(int n) {
        this.commentsCount = n;
    }

    public boolean isLiked() {
        return this.isLiked;
    }

    public void setLiked(boolean bl) {
        this.isLiked = bl;
    }

    public b getUserVoteStatus() {
        return this.userVoteStatus;
    }

    public void setUserVoteStatus(b b2) {
        this.userVoteStatus = b2;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(String string2) {
        this.colorCode = string2;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long l) {
        this.date = l;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String string2) {
        this.creatorName = string2;
    }

    public JSONObject getFeatureJsonObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_TITLE, (Object)this.getTitle()).put(KEY_DESCRIPTION, (Object)this.getDescription());
        return jSONObject;
    }

    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_ID, this.getFeatureId()).put(KEY_TITLE, (Object)this.getTitle()).put(KEY_DESCRIPTION, (Object)this.getDescription()).put(KEY_STATUS, this.getStatus().a()).put(KEY_DATE, this.getDate()).put(KEY_LIKES_COUNT, this.getLikesCount()).put(KEY_COMMENTS_COUNT, this.getCommentsCount()).put(KEY_IS_LIKED, this.isLiked()).put(KEY_VOTE_UPDATED, this.getUserVoteStatus().a()).put(KEY_COLOR_CODE, (Object)this.getColorCode()).put(KEY_CREATOR_NAME, (Object)this.getCreatorName());
        return jSONObject.toString();
    }

    public void fromJson(String string2) throws JSONException {
        int n;
        InstabugSDKLogger.d((Object)this, (String)string2);
        JSONObject jSONObject = new JSONObject(string2);
        if (jSONObject.has(KEY_ID)) {
            this.setFeatureId(jSONObject.getLong(KEY_ID));
        }
        if (jSONObject.has(KEY_TITLE)) {
            this.setTitle(jSONObject.getString(KEY_TITLE));
        }
        if (jSONObject.has(KEY_DESCRIPTION)) {
            this.setDescription(jSONObject.getString(KEY_DESCRIPTION));
        }
        if (jSONObject.has(KEY_CREATOR_NAME)) {
            this.setCreatorName(jSONObject.getString(KEY_CREATOR_NAME));
        }
        if (jSONObject.has(KEY_STATUS)) {
            n = jSONObject.getInt(KEY_STATUS);
            switch (n) {
                case 0: {
                    this.setStatus(a.Open);
                    break;
                }
                case 1: {
                    this.setStatus(a.Planned);
                    break;
                }
                case 2: {
                    this.setStatus(a.InProgress);
                    break;
                }
                case 3: {
                    this.setStatus(a.Completed);
                    break;
                }
                case 4: {
                    this.setStatus(a.MaybeLater);
                    break;
                }
            }
        }
        if (jSONObject.has(KEY_COLOR_CODE)) {
            this.setColorCode(jSONObject.getString(KEY_COLOR_CODE));
        }
        if (jSONObject.has(KEY_LIKES_COUNT)) {
            this.setLikesCount(jSONObject.getInt(KEY_LIKES_COUNT));
        }
        if (jSONObject.has(KEY_DATE)) {
            this.setDate(jSONObject.getLong(KEY_DATE));
        }
        if (jSONObject.has(KEY_COMMENTS_COUNT)) {
            this.setCommentsCount(jSONObject.getInt(KEY_COMMENTS_COUNT));
        }
        if (jSONObject.has(KEY_IS_LIKED)) {
            this.setLiked(jSONObject.getBoolean(KEY_IS_LIKED));
        }
        if (jSONObject.has(KEY_VOTE_UPDATED)) {
            n = jSONObject.getInt(KEY_VOTE_UPDATED);
            switch (n) {
                case 0: {
                    this.setUserVoteStatus(b.NOTHING);
                    break;
                }
                case 1: {
                    this.setUserVoteStatus(b.UPLOADED);
                    break;
                }
                case 2: {
                    this.setUserVoteStatus(b.USER_VOTED_UP);
                    break;
                }
                case 3: {
                    this.setUserVoteStatus(b.USER_UN_VOTED);
                    break;
                }
                default: {
                    this.setUserVoteStatus(b.NOTHING);
                }
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string2) {
        this.description = string2;
    }

    public boolean isCompleted() {
        return this.getStatus() == a.Completed;
    }

    public static enum b {
        NOTHING(0),
        UPLOADED(1),
        USER_VOTED_UP(2),
        USER_UN_VOTED(3);

        private int status;

        private b(int n2) {
            this.status = n2;
        }

        public int a() {
            return this.status;
        }
    }

    public static enum a {
        Open(0),
        Planned(1),
        InProgress(2),
        Completed(3),
        MaybeLater(4);

        private int status;

        private a(int n2) {
            this.status = n2;
        }

        public int a() {
            return this.status;
        }
    }
}

