/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.cache;

import android.support.annotation.Nullable;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class FeatureRequestCacheManager {
    public static final String FEATURES_REQUEST_DISK_CACHE_FILE_NAME = "/features_request.cache";
    public static final String FEATURES_REQUEST_DISK_CACHE_KEY = "features_request_disk_cache";
    public static final String FEATURES_REQUEST_MEMORY_CACHE_KEY = "features_request_memory_cache";
    public static final String FEATURES_REQUESTS_EXTRAS_DISK_CACHE_FILE_NAME = "/features_request_extras.cache";
    public static final String FEATURES_REQUESTS_EXTRAS_DISK_CACHE_KEY = "features_request_extras_disk_cache";
    public static final String FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY = "features_request_extras_memory_cache";
    private final String TAG = this.getClass().getSimpleName();

    public static InMemoryCache<Long, FeatureRequest> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(FEATURES_REQUEST_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("In-memory features requet cache not found, loading it from disk " + CacheManager.getInstance().getCache(FEATURES_REQUEST_MEMORY_CACHE_KEY)));
            CacheManager.getInstance().migrateCache(FEATURES_REQUEST_DISK_CACHE_KEY, FEATURES_REQUEST_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<Long, FeatureRequest>(){

                public Long a(FeatureRequest featureRequest) {
                    return featureRequest.getFeatureId();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((FeatureRequest)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(FEATURES_REQUEST_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("In-memory Feature Request cache restored from disk, " + cache.size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)"In-memory features request cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(FEATURES_REQUEST_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        int n;
        Cache cache = CacheManager.getInstance().getCache(FEATURES_REQUEST_DISK_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(FEATURES_REQUEST_MEMORY_CACHE_KEY);
        if (cache != null && cache2 != null) {
            InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("Checking old values cached " + cache.getValues()));
            InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("Saving In-memory feature requests cache to disk, no. of feature requests to save is " + cache2.size()));
            CacheManager.getInstance().migrateCache(cache2, cache, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, FeatureRequest>(){

                public String a(FeatureRequest featureRequest) {
                    return String.valueOf(featureRequest.getFeatureId());
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((FeatureRequest)object);
                }
            });
            n = cache.getValues().size();
        } else {
            n = 0;
        }
        InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("In-memory feature requests cache had been persisted on-disk, " + n + " feautre reuests saved"));
    }

    public static void addFeatures(List<FeatureRequest> list) {
        for (FeatureRequest featureRequest : list) {
            FeatureRequestCacheManager.addFeature(featureRequest);
        }
    }

    public static void addFeature(FeatureRequest featureRequest) {
        InMemoryCache<Long, FeatureRequest> inMemoryCache = FeatureRequestCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put((Object)featureRequest.getFeatureId(), (Object)featureRequest);
        }
    }

    public static List<FeatureRequest> getFeatures() {
        InMemoryCache<Long, FeatureRequest> inMemoryCache = FeatureRequestCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.getValues();
        }
        return new ArrayList<FeatureRequest>();
    }

    @Nullable
    public static FeatureRequest getFeature(long l) {
        InMemoryCache<Long, FeatureRequest> inMemoryCache = FeatureRequestCacheManager.getCache();
        if (inMemoryCache != null) {
            for (FeatureRequest featureRequest : inMemoryCache.getValues()) {
                if (featureRequest.getFeatureId() != l) continue;
                return featureRequest;
            }
        }
        return null;
    }

    public static List<FeatureRequest> getVotesToUpload() {
        ArrayList<FeatureRequest> arrayList = new ArrayList<FeatureRequest>();
        InMemoryCache<Long, FeatureRequest> inMemoryCache = FeatureRequestCacheManager.getCache();
        if (inMemoryCache != null) {
            List list = inMemoryCache.getValues();
            InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("size: " + list.size()));
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static InMemoryCache<String, Object> getExtrasCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("In-memory features request extas cache not found, loading it from disk " + CacheManager.getInstance().getCache(FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY)));
            CacheManager.getInstance().migrateCache(FEATURES_REQUESTS_EXTRAS_DISK_CACHE_KEY, FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, Object>(){

                public String a(Object object) {
                    return object instanceof Boolean ? "has_next_page" : "completed_features_count";
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a(object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("In-memory Feature Request extras cache restored from disk, " + cache.size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)"In-memory features request extras cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY);
    }

    public static void saveExtrasCacheToDisk() {
        int n;
        Cache cache = CacheManager.getInstance().getCache(FEATURES_REQUESTS_EXTRAS_DISK_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(FEATURES_REQUESTS_EXTRAS_MEMORY_CACHE_KEY);
        if (cache != null && cache2 != null) {
            InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("Checking old values cached " + cache.getValues()));
            InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("Saving In-memory feature requests extras cache to disk, no. of feature requests to save is " + cache2.size()));
            CacheManager.getInstance().migrateCache(cache2, cache, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, Object>(){

                public String a(Object object) {
                    return object instanceof Boolean ? "has_next_page" : "completed_features_count";
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a(object);
                }
            });
            n = cache.getValues().size();
        } else {
            n = 0;
        }
        InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)("In-memory feature requests extras cache had been persisted on-disk, " + n + " feauture requests extras saved"));
    }

    public static void setHasNextPage(boolean bl) {
        InMemoryCache<String, Object> inMemoryCache = FeatureRequestCacheManager.getExtrasCache();
        if (inMemoryCache != null) {
            inMemoryCache.put((Object)"has_next_page", (Object)bl);
        }
    }

    public static boolean hasNextPage() {
        InMemoryCache<String, Object> inMemoryCache = FeatureRequestCacheManager.getExtrasCache();
        if (inMemoryCache != null && inMemoryCache.get((Object)"has_next_page") != null) {
            return (Boolean)inMemoryCache.get((Object)"has_next_page");
        }
        return false;
    }

    public static int getCompletedFeaturesCount() {
        InMemoryCache<String, Object> inMemoryCache = FeatureRequestCacheManager.getExtrasCache();
        if (inMemoryCache != null && inMemoryCache.get((Object)"completed_features_count") != null) {
            return (Integer)inMemoryCache.get((Object)"completed_features_count");
        }
        return 0;
    }

    public static void setCompletedFeaturesCount(int n) {
        InMemoryCache<String, Object> inMemoryCache = FeatureRequestCacheManager.getExtrasCache();
        if (inMemoryCache != null) {
            inMemoryCache.put((Object)"completed_features_count", (Object)n);
        }
    }
}

