package com.instabug.featuresrequest.ui.featuresmain;

import androidx.annotation.Nullable;

import com.instabug.library.core.ui.BasePresenter;

/**
 * @author hossam.
 */

public class FeaturesMainPresenter extends BasePresenter<FeaturesMainContract.View>
        implements FeaturesMainContract.Presenter {

    @Nullable
    private final FeaturesMainContract.View viewInstance;

    public FeaturesMainPresenter(FeaturesMainContract.View view) {
        super(view);

        viewInstance = this.view.get();
    }

    @Override
    public void onAddFeatureButtonClicked() {
        if (viewInstance != null) {
            viewInstance.navigateToAddNewFeatureScreen();
        }
    }

    @Override
    public void onSearchButtonClicked() {
        if (viewInstance != null) {
            viewInstance.navigateToSearchScreen();
        }
    }

    @Override
    public void onCloseButtonClicked() {
        if (viewInstance != null) {
            viewInstance.closeFeatureRequestsMainScreen();
        }
    }
}
