package com.instabug.featuresrequest.utils;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.view.View;

import androidx.annotation.Nullable;

/**
 * Created by mohamedzakaria on 9/18/17.
 */

public class DrawableUtils {
    public static void setColor(@Nullable View view, int color) {
        if (view != null) {
            Drawable background = view.getBackground();
            if (background instanceof ShapeDrawable) {
                ((ShapeDrawable) background).getPaint().setColor(color);
            } else if (background instanceof GradientDrawable) {
                ((GradientDrawable) background).setColor(color);
            } else if (background instanceof ColorDrawable) {
                ((ColorDrawable) background).setColor(color);
            }
        }
    }
}
