package com.instabug.featuresrequest;

import static com.instabug.library.util.LocaleUtils.getLocaleStringResource;

import android.content.Context;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.featuresrequest.settings.FeaturesRequestSettings;
import com.instabug.featuresrequest.settings.PersistableSettings;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.PlaceHolderUtils;

public class FeaturesRequestPluginWrapper {

    public static void init(Context context) {
        PersistableSettings.init(context);
    }

    public static long getLastActivityTime() {
        return FeaturesRequestSettings.getInstance().getLastActivityTime();
    }


    @Nullable
    private static String getTitle(Context context) {
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.REQUEST_FEATURE,
                getLocaleStringResource(InstabugCore.getLocale(context),
                        com.instabug.library.R.string.instabug_str_request_feature, context));
    }

    @Nullable
    private static String getDescription(Context context) {
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.REQUEST_FEATURE_DESCRIPTION,
                getLocaleStringResource(InstabugCore.getLocale(context),
                        com.instabug.library.R.string.ib_fr_request_feature_description, context));
    }
}
