package com.instabug.featuresrequest.ui.newfeature;

import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;

import com.instabug.library.core.ui.BaseContract;

/**
 * @author hossam.
 */

public class AddNewFeatureContract {

    interface View extends BaseContract.View<Fragment> {

        void navigateToThanksScreen();

        void showCustomToast(String message);

        void showCustomToast(@StringRes int resId);

        void showProgressbarDialog();

        void hideProgressbarDialog();

        void showExitDialog();

        void setUserName(String userName);

        @Nullable
        String getFeatureTitle();

        String getFeatureDescription();

        String getEmailString();

        String getNameString();

        void setUserEmail(String userEmail);

        void setEmailHintStringWithAsterisk(boolean withAsterisk);

        void close();

        @Nullable
        String getValidEmail();

        void hideUserEmail();

        void hideUserName();
    }

    interface Presenter extends BaseContract.Presenter {

        void onAddButtonClicked();

        @Nullable
        String getEnteredEmail();

        @Nullable
        String getEnteredUsername();

        void handelRequiredFieldsHints();
    }
}